/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.controls;

import com.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class MachineSlotWidget {
    protected int x;
    protected int y;
    protected int guiLeft;
    protected int guiTop;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected MachineReference machine;
    protected Font fontRenderer;
    protected int slotHighlightColor;

    public MachineSlotWidget(IStorageControllerGuiContainer parent, @Nonnull MachineReference machine, int x, int y, int guiLeft, int guiTop) {
        this.x = x;
        this.y = y;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.parent = parent;
        this.minecraft = Minecraft.getInstance();
        this.machine = machine;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public MachineReference getMachine() {
        return this.machine;
    }

    public void setMachine(MachineReference machine) {
        this.machine = machine;
    }

    public boolean isMouseOverSlot(double mouseX, double mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(GuiGraphics guiGraphics, int mx, int my) {
        guiGraphics.pose().pushPose();
        boolean isMouseOverSlot = this.isMouseOverSlot(mx, my);
        if (isMouseOverSlot) {
            guiGraphics.renderItem(this.machine.getExtractItemStack(), this.x, this.y);
        } else {
            guiGraphics.renderItem(this.machine.getInsertItemStack(), this.x, this.y);
        }
        if (isMouseOverSlot) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.parent.drawGradientRect(guiGraphics, this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        guiGraphics.pose().popPose();
    }

    public void drawTooltip(GuiGraphics guiGraphics, int mx, int my) {
        if (this.isMouseOverSlot(mx, my)) {
            this.parent.renderToolTip(guiGraphics, this.machine, mx, my);
        }
    }
}

