/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SavedUpgrades {
    private static final Codec<PNCUpgrade> UPGRADE_CODEC = ResourceLocation.CODEC.xmap(id -> ApplicableUpgradesDB.getInstance().getUpgradeById((ResourceLocation)id), PNCUpgrade::getId);
    private static final StreamCodec<ByteBuf, PNCUpgrade> UPGRADE_STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(id -> ApplicableUpgradesDB.getInstance().getUpgradeById((ResourceLocation)id), PNCUpgrade::getId);
    public static final Codec<SavedUpgrades> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemContainerContents.CODEC.fieldOf("upgrades").forGetter(s -> s.contents), (App)Codec.unboundedMap(UPGRADE_CODEC, (Codec)ExtraCodecs.POSITIVE_INT).fieldOf("map").forGetter(s -> s.map)).apply((Applicative)builder, SavedUpgrades::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SavedUpgrades> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemContainerContents.STREAM_CODEC, s -> s.contents, (StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, UPGRADE_STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), s -> s.map, SavedUpgrades::new);
    public static final SavedUpgrades EMPTY = new SavedUpgrades(ItemContainerContents.EMPTY, Map.of());
    private final ItemContainerContents contents;
    private final Map<PNCUpgrade, Integer> map;

    private SavedUpgrades(ItemContainerContents contents, Map<PNCUpgrade, Integer> map) {
        this.contents = contents;
        this.map = map;
    }

    public static SavedUpgrades fromItemHandler(IItemHandler upgradeHandler, ToIntFunction<PNCUpgrade> maxCalculator) {
        HashMap<PNCUpgrade, Integer> map = new HashMap<PNCUpgrade, Integer>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(upgradeHandler.getSlots());
        for (int i = 0; i < upgradeHandler.getSlots(); ++i) {
            ItemStack stack = upgradeHandler.getStackInSlot(i);
            items.add(stack);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            PNCUpgrade type = upgradeItem.getUpgradeType();
            int maxAllowed = maxCalculator.applyAsInt(type);
            map.put(type, Math.min(maxAllowed, map.getOrDefault(type, 0) + stack.getCount()) * upgradeItem.getUpgradeTier());
        }
        return new SavedUpgrades(ItemContainerContents.fromItems(items), Collections.unmodifiableMap(map));
    }

    public int getUpgradeCount(PNCUpgrade upgrade) {
        return this.map.getOrDefault(upgrade, 0);
    }

    public Map<PNCUpgrade, Integer> getUpgradeMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public IItemHandler getUpgradeHandler() {
        ItemStackHandler res = new ItemStackHandler(this.contents.getSlots());
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            res.setStackInSlot(i, this.contents.getStackInSlot(i));
        }
        return res;
    }

    public void fillItemHandler(ItemStackHandler handler) {
        for (int i = 0; i < this.contents.getSlots() && i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, this.contents.getStackInSlot(i));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedUpgrades that = (SavedUpgrades)o;
        return Objects.equals(this.contents, that.contents) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.contents, this.map);
    }
}

