/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class EntityProvider {
    private static final ResourceLocation ID = PneumaticRegistry.RL("entity");

    public static class ComponentProvider
    implements IEntityComponentProvider {
        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            Entity entity;
            if (entityAccessor.getServerData().contains("Pressure")) {
                float pressure = entityAccessor.getServerData().getFloat("Pressure");
                iTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1)));
            }
            if (entityAccessor.getServerData().contains("Temperature")) {
                iTooltip.add(HeatUtil.formatHeatString(entityAccessor.getServerData().getInt("Temperature")));
            }
            if ((entity = entityAccessor.getEntity()) instanceof ISemiBlock) {
                ISemiBlock semiBlock = (ISemiBlock)entity;
                semiBlock.addTooltip(arg_0 -> ((ITooltip)iTooltip).add(arg_0), entityAccessor.getPlayer(), entityAccessor.getServerData(), entityAccessor.getPlayer().isShiftKeyDown());
                BlockPos pos = semiBlock.getBlockPos();
                BlockState state = entityAccessor.getLevel().getBlockState(pos);
                iTooltip.add((Component)state.getBlock().getName().withStyle(ChatFormatting.YELLOW));
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    public static class DataProvider
    implements IServerDataProvider<EntityAccessor> {
        public ResourceLocation getUid() {
            return ID;
        }

        public void appendServerData(CompoundTag compoundTag, EntityAccessor accessor) {
            IOHelper.getCapV(accessor.getEntity(), PNCCapabilities.AIR_HANDLER_ENTITY).ifPresent(h -> compoundTag.putFloat("Pressure", h.getPressure()));
            IOHelper.getCapV(accessor.getEntity(), PNCCapabilities.HEAT_EXCHANGER_ENTITY).ifPresent(h -> compoundTag.putFloat("Temperature", (float)h.getTemperatureAsInt()));
            if (accessor instanceof ISemiBlock) {
                ISemiBlock s = (ISemiBlock)accessor;
                s.serializeNBT(compoundTag, (HolderLookup.Provider)accessor.getEntity().registryAccess());
            }
        }
    }
}

