/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.crafttweaker;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidContainerIngredient;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CTUtils {
    public static SizedIngredient toSizedIngredient(IIngredientWithAmount ingredient) {
        return new SizedIngredient(ingredient.ingredient().asVanillaIngredient(), ingredient.amount());
    }

    public static List<SizedIngredient> toSizedIngredientList(IIngredientWithAmount[] ingredients) {
        return Arrays.stream(ingredients).map(CTUtils::toSizedIngredient).toList();
    }

    public static List<ItemStack> toItemStacks(IItemStack[] stacks) {
        return Arrays.stream(stacks).map(IItemStack::getInternal).toList();
    }

    public static List<FluidStack> toFluidStacks(MCFluidStack[] stacks) {
        return Arrays.stream(stacks).map(MCFluidStack::getImmutableInternal).toList();
    }

    public static FluidIngredient toFluidIngredient(CTFluidIngredient ingredient) {
        return (FluidIngredient)ingredient.mapTo(fStack -> FluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack(fStack.getFluid(), (int)fStack.getAmount())}), (tag, amount) -> FluidIngredient.tag((TagKey)tag), CTUtils::flattenIngredients);
    }

    public static SizedFluidIngredient toSizedFluidIngredient(CTFluidIngredient ingredient) {
        return (SizedFluidIngredient)ingredient.mapTo(fluidStack -> SizedFluidIngredient.of((Fluid)fluidStack.getFluid(), (int)((int)fluidStack.getAmount())), SizedFluidIngredient::of, stream -> stream.findFirst().map(ingr -> new SizedFluidIngredient(ingr.ingredient(), ingr.amount())).orElseThrow());
    }

    private static FluidIngredient flattenIngredients(Stream<FluidIngredient> stream) {
        return FluidIngredient.of((Fluid[])((Fluid[])stream.flatMap(ingredient -> Arrays.stream(ingredient.getStacks())).map(FluidStack::getFluid).distinct().toArray(Fluid[]::new)));
    }

    public static FluidContainerIngredient toFluidContainerIngredient(CTFluidIngredient ingredient) {
        return (FluidContainerIngredient)ingredient.mapTo(fluidStack -> FluidContainerIngredient.of(fluidStack.getFluid(), (int)fluidStack.getAmount()), FluidContainerIngredient::of, stream -> (FluidContainerIngredient)stream.findFirst().orElseThrow());
    }
}

