/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorItem;
import me.desht.pneumaticcraft.common.item.CreativeTabStackProvider;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliBookCrafting;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModCreativeModeTab {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"pneumaticcraft");
    public static final Supplier<CreativeModeTab> DEFAULT = TABS.register("default", ModCreativeModeTab::buildDefaultTab);

    private static CreativeModeTab buildDefaultTab() {
        return CreativeModeTab.builder().title((Component)PneumaticCraftUtils.xlate("itemGroup.pneumaticcraft", new Object[0])).icon(() -> new ItemStack((ItemLike)ModItems.PRESSURE_GAUGE.get())).displayItems(ModCreativeModeTab::genDisplayItems).build();
    }

    private static void genDisplayItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        List items = ModItems.ITEMS.getEntries().stream().flatMap(ro -> ModCreativeModeTab.stacksForItem((Item)ro.get())).sorted(new ItemSorter()).collect(Collectors.toCollection(ArrayList::new));
        if (ModList.get().isLoaded("patchouli")) {
            items.add(PatchouliBookCrafting.makeGuideBook());
        }
        output.acceptAll((Collection)items);
    }

    private static Stream<ItemStack> stacksForItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        Item item2 = item;
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CreativeTabStackProvider.class, BlockItem.class, IPressurizableItem.class}, (Object)item3, n)) {
                case 0: {
                    CreativeTabStackProvider provider = (CreativeTabStackProvider)item3;
                    return provider.getStacksForItem();
                }
                case 1: {
                    BlockItem bi = (BlockItem)item3;
                    Block block = bi.getBlock();
                    if (!(block instanceof CreativeTabStackProvider)) {
                        n = 2;
                        continue block5;
                    }
                    CreativeTabStackProvider provider = (CreativeTabStackProvider)block;
                    return provider.getStacksForItem();
                }
                case 2: {
                    IPressurizableItem p = (IPressurizableItem)item3;
                    ItemStack stack2 = stack.copy();
                    new AirHandlerItemStack(stack2).addAir((int)((float)p.getBaseVolume() * p.getMaxPressure()));
                    return Stream.of(new ItemStack((ItemLike)item), stack2);
                }
            }
            break;
        }
        return Stream.of(stack);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private ItemSorter() {
        }

        @Override
        public int compare(ItemStack s1, ItemStack s2) {
            for (Class<PneumaticCraftBucketItem> cls : List.of(BlockItem.class, PressurizableItem.class, CompressedIronArmorItem.class, PneumaticArmorItem.class, SemiblockItem.class, AbstractGunAmmoItem.class, UpgradeItem.class, TubeModuleItem.class, PneumaticCraftBucketItem.class)) {
                if (cls.isAssignableFrom(s1.getItem().getClass()) && !cls.isAssignableFrom(s2.getItem().getClass())) {
                    return -1;
                }
                if (!cls.isAssignableFrom(s2.getItem().getClass()) || cls.isAssignableFrom(s1.getItem().getClass())) continue;
                return 1;
            }
            return s1.getDisplayName().getString().compareTo(s2.getDisplayName().getString());
        }
    }
}

