/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class ThermoPlantRecipeImpl
extends ThermoPlantRecipe {
    private final ThermoPlantRecipe.Inputs inputs;
    private final ThermoPlantRecipe.Outputs outputs;
    private final float requiredPressure;
    private final float recipeSpeed;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final float airUseMultiplier;

    public ThermoPlantRecipeImpl(ThermoPlantRecipe.Inputs inputs, ThermoPlantRecipe.Outputs outputs, TemperatureRange operatingTemperature, float requiredPressure, float recipeSpeed, float airUseMultiplier, boolean exothermic) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.recipeSpeed = recipeSpeed;
        this.airUseMultiplier = airUseMultiplier;
        this.exothermic = exothermic;
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        boolean itemOK = this.inputs.inputItem().map(ingr -> ingr.test(itemStack)).orElse(itemStack.isEmpty());
        boolean fluidOK = this.inputs.inputFluid().map(ingr -> ingr.ingredient().test(fluidStack)).orElse(fluidStack.isEmpty());
        return itemOK && fluidOK;
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public Optional<SizedFluidIngredient> getInputFluid() {
        return this.inputs.inputFluid();
    }

    @Override
    @Nonnull
    public Optional<Ingredient> getInputItem() {
        return this.inputs.inputItem();
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputs.outputFluid();
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputs.outputItem();
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public ThermoPlantRecipe.Inputs inputs() {
        return this.inputs;
    }

    @Override
    public ThermoPlantRecipe.Outputs outputs() {
        return this.outputs;
    }

    @Override
    public float getRecipeSpeed() {
        return this.recipeSpeed;
    }

    @Override
    public float getAirUseMultiplier() {
        return this.airUseMultiplier;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.THERMO_PLANT.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.THERMO_PLANT.get();
    }

    public String getGroup() {
        return "pneumaticcraft:thermo_plant";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get());
    }

    public static class Serializer<T extends ThermoPlantRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ThermoPlantRecipe.Inputs.CODEC.fieldOf("inputs").forGetter(ThermoPlantRecipe::inputs), (App)ThermoPlantRecipe.Outputs.CODEC.fieldOf("outputs").forGetter(ThermoPlantRecipe::outputs), (App)TemperatureRange.CODEC.optionalFieldOf("temperature", (Object)TemperatureRange.any()).forGetter(ThermoPlantRecipe::getOperatingTemperature), (App)Codec.FLOAT.optionalFieldOf("pressure", (Object)Float.valueOf(0.0f)).forGetter(ThermoPlantRecipe::getRequiredPressure), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(ThermoPlantRecipe::getRecipeSpeed), (App)Codec.FLOAT.optionalFieldOf("air_use_multiplier", (Object)Float.valueOf(1.0f)).forGetter(ThermoPlantRecipe::getAirUseMultiplier), (App)Codec.BOOL.optionalFieldOf("exothermic", (Object)false).forGetter(ThermoPlantRecipe::isExothermic)).apply((Applicative)inst, factory::create)).validate(recipe -> recipe.getInputItem().isPresent() || recipe.getInputFluid().isPresent() ? DataResult.success((Object)recipe) : DataResult.error(() -> "at least one of item_input or fluid_input must be present!", (Object)recipe));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = NeoForgeStreamCodecs.composite(ThermoPlantRecipe.Inputs.STREAM_CODEC, ThermoPlantRecipe::inputs, ThermoPlantRecipe.Outputs.STREAM_CODEC, ThermoPlantRecipe::outputs, TemperatureRange.STREAM_CODEC, ThermoPlantRecipe::getOperatingTemperature, (StreamCodec)ByteBufCodecs.FLOAT, ThermoPlantRecipe::getRequiredPressure, (StreamCodec)ByteBufCodecs.FLOAT, ThermoPlantRecipe::getRecipeSpeed, (StreamCodec)ByteBufCodecs.FLOAT, ThermoPlantRecipe::getAirUseMultiplier, (StreamCodec)ByteBufCodecs.BOOL, ThermoPlantRecipe::isExothermic, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends ThermoPlantRecipe> {
        public T create(ThermoPlantRecipe.Inputs var1, ThermoPlantRecipe.Outputs var2, TemperatureRange var3, float var4, float var5, float var6, boolean var7);
    }
}

