/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.client.gui.MicromissileScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class MicromissilesItem
extends Item {
    public MicromissilesItem() {
        super(ModItems.defaultProps().stacksTo(1).durability(100).component(ModDataComponents.MICROMISSILE_SETTINGS, (Object)Settings.DEFAULT));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().micromissiles.missilePodSize.get();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return toRepair.getItem() == this && repair.getItem() == Blocks.TNT.asItem();
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (stack.get(ModDataComponents.MICROMISSILE_SETTINGS) == Settings.DEFAULT) {
            stack.set(ModDataComponents.MICROMISSILE_SETTINGS, (Object)MicromissileDefaults.INSTANCE.getDefaults(playerIn));
        }
        if (playerIn.isShiftKeyDown()) {
            if (worldIn.isClientSide) {
                MicromissileScreen.openGui(stack.getHoverName(), handIn);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        MicromissileEntity missile = new MicromissileEntity(worldIn, (LivingEntity)playerIn, stack);
        Vec3 newPos = missile.position().add(playerIn.getLookAngle().normalize());
        missile.setPos(newPos.x, newPos.y, newPos.z);
        missile.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, this.getInitialVelocity(stack), 0.0f);
        playerIn.getCooldowns().addCooldown((Item)this, ((Integer)ConfigHelper.common().micromissiles.launchCooldown.get()).intValue());
        Level level = playerIn.level();
        if (level instanceof ServerLevel) {
            EntityHitResult ertr;
            ServerLevel serverLevel = (ServerLevel)level;
            HitResult res = RayTraceUtils.getMouseOverServer((LivingEntity)playerIn, 100.0);
            if (res instanceof EntityHitResult && missile.isValidTarget((ertr = (EntityHitResult)res).getEntity())) {
                missile.setTarget(ertr.getEntity());
            }
            worldIn.addFreshEntity((Entity)missile);
            if (!playerIn.isCreative()) {
                stack.hurtAndBreak(1, serverLevel, (LivingEntity)playerIn, item -> {});
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)playerIn.level().isClientSide());
    }

    private float getInitialVelocity(ItemStack stack) {
        Settings settings = (Settings)stack.getOrDefault(ModDataComponents.MICROMISSILE_SETTINGS, (Object)Settings.DEFAULT);
        return settings.fireMode() == FireMode.SMART ? Math.max(0.2f, settings.topSpeed() / 2.0f) : 0.33333334f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag extraInfo) {
        super.appendHoverText(stack, context, curInfo, extraInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.remaining", new Object[0]).append((Component)Component.literal((String)Integer.toString(stack.getMaxDamage() - stack.getDamageValue())).withStyle(ChatFormatting.AQUA)));
        if (stack.has(ModDataComponents.MICROMISSILE_SETTINGS)) {
            String filter;
            FireMode mode = MicromissilesItem.getFireMode(stack);
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.firingMode", new Object[0]).append(": ").append((Component)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA)));
            if (mode == FireMode.SMART && !(filter = ((Settings)stack.get(ModDataComponents.MICROMISSILE_SETTINGS)).entityFilter()).isEmpty()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]).append(": ").append(String.valueOf(ChatFormatting.AQUA) + filter));
            }
        }
        if (((Boolean)ConfigHelper.common().micromissiles.damageTerrain.get()).booleanValue()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainWarning", new Object[0]));
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainSafe", new Object[0]));
        }
    }

    public static void setEntityFilter(ItemStack stack, String filterString) {
        if (stack.getItem() instanceof MicromissilesItem) {
            Settings settings = (Settings)stack.getOrDefault(ModDataComponents.MICROMISSILE_SETTINGS, (Object)Settings.DEFAULT);
            stack.set(ModDataComponents.MICROMISSILE_SETTINGS, (Object)settings.withEntityFilter(filterString));
        }
    }

    public static FireMode getFireMode(ItemStack stack) {
        return ((Settings)stack.getOrDefault(ModDataComponents.MICROMISSILE_SETTINGS, (Object)Settings.DEFAULT)).fireMode();
    }

    public record Settings(float topSpeed, float turnSpeed, float damage, PointXY point, String entityFilter, FireMode fireMode) {
        public static final Codec<Settings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("top_speed").forGetter(Settings::topSpeed), (App)Codec.FLOAT.fieldOf("turn_speed").forGetter(Settings::turnSpeed), (App)Codec.FLOAT.fieldOf("damage").forGetter(Settings::damage), (App)PointXY.CODEC.fieldOf("point").forGetter(Settings::point), (App)Codec.STRING.fieldOf("filter").forGetter(Settings::entityFilter), (App)StringRepresentable.fromEnum(FireMode::values).fieldOf("fire_mode").forGetter(Settings::fireMode)).apply((Applicative)builder, Settings::new));
        public static final StreamCodec<FriendlyByteBuf, Settings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Settings::topSpeed, (StreamCodec)ByteBufCodecs.FLOAT, Settings::turnSpeed, (StreamCodec)ByteBufCodecs.FLOAT, Settings::damage, PointXY.STREAM_CODEC, Settings::point, (StreamCodec)ByteBufCodecs.STRING_UTF8, Settings::entityFilter, (StreamCodec)NeoForgeStreamCodecs.enumCodec(FireMode.class), Settings::fireMode, Settings::new);
        public static final Settings DEFAULT = new Settings(0.33333334f, 0.33333334f, 0.33333334f, new PointXY(46, 54), "", FireMode.SMART);

        public Settings withEntityFilter(String filterString) {
            return new Settings(this.topSpeed, this.turnSpeed, this.damage, this.point, filterString, this.fireMode);
        }
    }

    public static enum FireMode implements ITranslatableEnum,
    StringRepresentable
    {
        SMART("smart"),
        DUMB("dumb");

        private final String mode;

        private FireMode(String mode) {
            this.mode = mode;
        }

        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.micromissile.mode." + this.mode;
        }

        public String getSerializedName() {
            return this.mode;
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMissilesRepair(AnvilRepairEvent event) {
            if (event.getOutput().getItem() instanceof MicromissilesItem) {
                event.getOutput().set(DataComponents.REPAIR_COST, (Object)0);
            }
        }
    }
}

