/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.common.inventory.slot.UnstackablePhantomSlot;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemSearcherMenu
extends AbstractContainerMenu {
    private static final int SEARCH_ROWS = 6;
    private static final int SEARCH_COLS = 8;
    public final NonNullList<ItemStack> itemList = NonNullList.create();
    private ItemSearcherScreen gui;

    public ItemSearcherMenu(int windowId, Inventory inv, FriendlyByteBuf data) {
        super(ModMenuTypes.ITEM_SEARCHER.get(), windowId);
    }

    public void init(ItemSearcherScreen gui) {
        this.gui = gui;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.addSlot((Slot)new UnstackablePhantomSlot((IItemHandler)gui.getInventory(), i * 8 + j, 8 + j * 18, 52 + i * 18));
            }
        }
        this.addSlot((Slot)new UnstackablePhantomSlot((IItemHandler)gui.getInventory(), 48, 148, 25));
        this.scrollTo(0.0);
    }

    public boolean stillValid(Player player) {
        return player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.PNEUMATIC_HELMET.get();
    }

    public void scrollTo(double scrollPos) {
        int i = this.itemList.size() / 8 - 6 + 1;
        int j = Math.max(0, (int)(scrollPos * (double)i + 0.5));
        for (int k = 0; k < 6; ++k) {
            for (int l = 0; l < 8; ++l) {
                int idx = l + (k + j) * 8;
                ItemStack stack = idx >= 0 && idx < this.itemList.size() ? (ItemStack)this.itemList.get(idx) : ItemStack.EMPTY;
                this.gui.getInventory().setStackInSlot(l + k * 8, stack);
            }
        }
    }

    public boolean hasMoreThan1PageOfItemsInList() {
        return this.itemList.size() > 48;
    }

    public ItemStack quickMoveStack(Player par1EntityPlayer, int par2) {
        return ItemStack.EMPTY;
    }

    public void setItem(int par1, int state, ItemStack par2ItemStack) {
    }
}

