/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ChargingStationUpgradeManagerMenu
extends AbstractPneumaticCraftMenu<ChargingStationBlockEntity> {
    private ChargingStationUpgradeManagerMenu(MenuType type, int windowId, Inventory inv, FriendlyByteBuf data) {
        this(type, windowId, inv, ChargingStationUpgradeManagerMenu.getTilePos(data));
    }

    public ChargingStationUpgradeManagerMenu(MenuType type, int windowId, Inventory inventoryPlayer, BlockPos pos) {
        super(type, windowId, inventoryPlayer, pos);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot((Slot)new UpgradeSlot((ChargingStationBlockEntity)this.blockEntity, i * 3 + j, 44 + j * 18, 34 + i * 18));
            }
        }
        this.addPlayerSlots(inventoryPlayer, 100);
    }

    public static ChargingStationUpgradeManagerMenu createMinigunContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ChargingStationUpgradeManagerMenu(ModMenuTypes.CHARGING_MINIGUN.get(), windowId, inv, data);
    }

    public static ChargingStationUpgradeManagerMenu createDroneContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ChargingStationUpgradeManagerMenu(ModMenuTypes.CHARGING_DRONE.get(), windowId, inv, data);
    }

    public static ChargingStationUpgradeManagerMenu createArmorContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ChargingStationUpgradeManagerMenu(ModMenuTypes.CHARGING_ARMOR.get(), windowId, inv, data);
    }

    public static ChargingStationUpgradeManagerMenu createJackhammerContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ChargingStationUpgradeManagerMenu(ModMenuTypes.CHARGING_JACKHAMMER.get(), windowId, inv, data);
    }

    public static ChargingStationUpgradeManagerMenu createAmadronContainer(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ChargingStationUpgradeManagerMenu(ModMenuTypes.CHARGING_AMADRON.get(), windowId, inv, data);
    }

    private class UpgradeSlot
    extends SlotItemHandler {
        UpgradeSlot(ChargingStationBlockEntity te, int slotIndex, int posX, int posY) {
            super((IItemHandler)te.getChargeableInventory(), slotIndex, posX, posY);
        }

        public int getMaxStackSize(@Nonnull ItemStack stack) {
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(((ChargingStationBlockEntity)ChargingStationUpgradeManagerMenu.this.blockEntity).getChargingStack().getItem(), PNCUpgrade.from(stack));
        }

        public void setChanged() {
            super.setChanged();
            ((ChargeableItemHandler)this.getItemHandler()).writeToChargingStack();
        }
    }
}

