/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.mixin.accessors.AbstractFurnaceBlockEntityAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HeatBehaviourFurnace
extends HeatBehaviour {
    static final ResourceLocation ID = PneumaticRegistry.RL("furnace");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean isApplicable() {
        return this.getBlockState().getBlock() instanceof AbstractFurnaceBlock;
    }

    @Override
    public void tick() {
        AbstractFurnaceBlockEntity furnace;
        BlockEntity blockEntity = this.getCachedTileEntity();
        if (!(blockEntity instanceof AbstractFurnaceBlockEntity) || (furnace = (AbstractFurnaceBlockEntity)blockEntity).isRemoved()) {
            return;
        }
        if (this.getHeatExchanger().getTemperature() > 373.0) {
            AbstractFurnaceBlockEntityAccess furnaceAccess = (AbstractFurnaceBlockEntityAccess)furnace;
            if (furnaceAccess.getLitTime() < 190 && !furnace.getItem(0).isEmpty()) {
                if (furnaceAccess.getLitTime() == 0) {
                    this.getWorld().setBlockAndUpdate(this.getPos(), (BlockState)this.getBlockState().setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)));
                }
                furnaceAccess.setLitDuration(200);
                furnaceAccess.setLitTime(furnaceAccess.getLitTime() + 10);
                this.getHeatExchanger().addHeat(-1.0);
            }
            if (furnaceAccess.getCookingProgress() > 0) {
                int progress = Math.max(0, ((int)this.getHeatExchanger().getTemperature() - 343) / 30);
                progress = Math.min(5, progress);
                for (int i = 0; i < progress; ++i) {
                    AbstractFurnaceBlockEntity.serverTick((Level)this.getWorld(), (BlockPos)furnace.getBlockPos(), (BlockState)furnace.getBlockState(), (AbstractFurnaceBlockEntity)furnace);
                }
            }
        }
    }
}

