/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.semiblock.ISpecificProvider;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class LogisticsStorageEntity
extends AbstractLogisticsFrameEntity
implements ISpecificProvider,
ISpecificRequester {
    private int minItems = 1;
    private int minFluid = 1;

    public LogisticsStorageEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public int getColor() {
        return -256;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.MODEL_LOGISTICS_FRAME_STORAGE;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    protected MenuType<?> getContainerType() {
        return ModMenuTypes.LOGISTICS_FRAME_STORAGE.get();
    }

    @Override
    public boolean canProvide(ItemStack providingStack) {
        return this.passesFilter(providingStack);
    }

    @Override
    public boolean canProvide(FluidStack providingStack) {
        return this.passesFilter(providingStack.getFluid());
    }

    @Override
    public int amountRequested(ItemStack stack) {
        return this.passesFilter(stack) ? stack.getMaxStackSize() : 0;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        return this.passesFilter(stack.getFluid()) ? stack.getAmount() : 0;
    }

    @Override
    public int getMinItemOrderSize() {
        return this.minItems;
    }

    @Override
    public void setMinItemOrderSize(int min) {
        this.minItems = min;
    }

    @Override
    public int getMinFluidOrderSize() {
        return this.minFluid;
    }

    @Override
    public void setMinFluidOrderSize(int min) {
        this.minFluid = min;
    }
}

