/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CropSupportEntity
extends AbstractSemiblockEntity {
    private static final AABB BOUNDS = new AABB(0.1875, 0.0, 0.1875, 0.8125, 0.5625, 0.8125);

    public CropSupportEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected AABB calculateBlockBounds() {
        return BOUNDS;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.random.nextDouble() < (Double)ConfigHelper.common().machines.cropSticksGrowthBoostChance.get() && !this.getBlockState().isAir()) {
            if (!level.isClientSide) {
                this.getBlockState().randomTick((ServerLevel)level, this.getBlockPos(), level.random);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockState state = this.getBlockState();
        return (state.isAir() || state.is(PneumaticCraftTags.Blocks.CROP_SUPPORT_GROWABLE)) && this.canStay();
    }

    @Override
    public boolean canStay() {
        BlockState state = this.getBlockState();
        if (!state.isAir()) {
            return true;
        }
        BlockPos posBelow = this.getBlockPos().relative(Direction.DOWN);
        BlockState stateBelow = this.level().getBlockState(posBelow);
        return !stateBelow.isAir();
    }

    @Override
    public InteractionResult interactAt(Player player, Vec3 hitVec, InteractionHand hand) {
        BlockState state = this.getBlockState();
        if (state.isAir()) {
            BlockPos below = this.getBlockPos().below();
            Vec3 eye = player.getEyePosition(0.0f);
            Vec3 end = Vec3.atCenterOf((Vec3i)below).add(0.0, 0.25, 0.0);
            ClipContext ctx = new ClipContext(eye, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult brtr = player.level().clip(ctx);
            if (brtr.getType() == HitResult.Type.BLOCK && brtr.getBlockPos().equals((Object)below)) {
                return player.getItemInHand(hand).useOn(new UseOnContext(player, hand, brtr));
            }
        }
        return super.interactAt(player, hitVec, hand);
    }
}

