/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypeCylinder
extends AreaType {
    public static final MapCodec<AreaTypeCylinder> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(CylinderType::values).optionalFieldOf("cylinder_type", (Object)CylinderType.FILLED).forGetter(t -> t.cylinderType), (App)StringRepresentable.fromEnum(AreaType.AreaAxis::values).optionalFieldOf("axis", (Object)AreaType.AreaAxis.X).forGetter(t -> t.axis)).apply((Applicative)builder, AreaTypeCylinder::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeCylinder> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(CylinderType.class), t -> t.cylinderType, (StreamCodec)NeoForgeStreamCodecs.enumCodec(AreaType.AreaAxis.class), t -> t.axis, AreaTypeCylinder::new);
    public static final String ID = "cylinder";
    private AreaType.AreaAxis axis;
    private CylinderType cylinderType;

    private AreaTypeCylinder(CylinderType cylinderType, AreaType.AreaAxis axis) {
        super(ID);
        this.axis = axis;
        this.cylinderType = cylinderType;
    }

    public AreaTypeCylinder() {
        this(CylinderType.FILLED, AreaType.AreaAxis.X);
    }

    @Override
    public AreaType copy() {
        return new AreaTypeCylinder(this.cylinderType, this.axis);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.cylinderType) + "/" + String.valueOf(this.axis);
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_CYLINDER.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                double rad = PneumaticCraftUtils.distBetween(p1.getY(), (double)p1.getZ(), (double)p2.getY(), (double)p2.getZ());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minY = (int)((double)p1.getY() - rad - 1.0);
                minZ = (int)((double)p1.getZ() - rad - 1.0);
                maxY = (int)((double)p1.getY() + rad + 1.0);
                maxZ = (int)((double)p1.getZ() + rad + 1.0);
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getY(), (double)p1.getZ(), (double)y, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int x = minX; x <= maxX; ++x) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != CylinderType.FILLED && (this.cylinderType != CylinderType.HOLLOW || x != minX && x != maxX)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Y: {
                double rad = PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.getX() - rad - 1.0);
                minZ = (int)((double)p1.getZ() - rad - 1.0);
                maxX = (int)((double)p1.getX() + rad + 1.0);
                maxZ = (int)((double)p1.getZ() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getX(), (double)p1.getZ(), (double)x, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int y = minY; y <= maxY; ++y) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != CylinderType.FILLED && (this.cylinderType != CylinderType.HOLLOW || y != minY && y != maxY)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Z: {
                double rad = PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.getX() - rad - 1.0);
                minY = (int)((double)p1.getY() - rad - 1.0);
                maxX = (int)((double)p1.getX() + rad + 1.0);
                maxY = (int)((double)p1.getY() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getX(), (double)p1.getY(), (double)x, (double)y);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != CylinderType.FILLED && (this.cylinderType != CylinderType.HOLLOW || z != minZ && z != maxZ)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<CylinderType>("pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType", CylinderType.class, () -> this.cylinderType, cylinderType -> {
            this.cylinderType = cylinderType;
        }));
        widgets.add(new AreaTypeWidget.EnumSelectorField<AreaType.AreaAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.AreaAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_CYLINDER: {
                this.axis = AreaType.AreaAxis.X;
                break;
            }
            case Y_CYLINDER: {
                this.axis = AreaType.AreaAxis.Y;
                break;
            }
            case Z_CYLINDER: {
                this.axis = AreaType.AreaAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeCylinder that = (AreaTypeCylinder)o;
        return this.axis == that.axis && this.cylinderType == that.cylinderType;
    }

    public int hashCode() {
        return Objects.hash(this.axis, this.cylinderType);
    }

    public static enum CylinderType implements ITranslatableEnum,
    StringRepresentable
    {
        FILLED("filled"),
        HOLLOW("hollow"),
        TUBE("tube");

        private final String name;

        private CylinderType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

