/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProgWidgetPressureCondition
extends ProgWidgetCondition {
    public static final MapCodec<ProgWidgetPressureCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetPressureCondition.condParts(builder).apply((Applicative)builder, ProgWidgetPressureCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetPressureCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCondition.ConditionFields.STREAM_CODEC, ProgWidgetCondition::conditionFields, ProgWidgetPressureCondition::new);

    public ProgWidgetPressureCondition() {
    }

    public ProgWidgetPressureCondition(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields inv, ProgWidgetCondition.ConditionFields cond) {
        super(pos, inv, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetPressureCondition(this.getPosition(), this.invBaseFields().copy(), this.conditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDrone drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.getDroneLevel().getBlockEntity(pos);
                if (te != null) {
                    float pressure = Float.MIN_VALUE;
                    for (Direction dir : DirectionUtil.VALUES) {
                        if (!ProgWidgetPressureCondition.this.isSideSelected(dir)) continue;
                        float p = PNCCapabilities.getAirHandler(te, dir).map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
                        pressure = Math.max(pressure, p);
                    }
                    ProgWidgetPressureCondition.this.maybeRecordMeasuredVal(this.drone, (int)(pressure * 1000.0f));
                    return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(pressure, (float)((ICondition)((Object)this.progWidget)).getRequiredCount());
                }
                return false;
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_PRESSURE;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_PRESSURE.get();
    }
}

