/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIAttackEntity;
import me.desht.pneumaticcraft.common.drone.ai.DroneAINearestAttackableTarget;
import me.desht.pneumaticcraft.common.drone.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICheckLineOfSight;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class ProgWidgetEntityAttack
extends ProgWidget
implements IAreaProvider,
IEntityProvider,
IMaxActions,
ICheckLineOfSight {
    public static final MapCodec<ProgWidgetEntityAttack> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetEntityAttack.baseParts(builder).and(builder.group((App)Codec.BOOL.optionalFieldOf("use_max_actions", (Object)false).forGetter(ProgWidgetEntityAttack::useMaxActions), (App)Codec.INT.optionalFieldOf("max_actions", (Object)1).forGetter(ProgWidgetEntityAttack::getMaxActions), (App)Codec.BOOL.optionalFieldOf("check_sight", (Object)false).forGetter(ProgWidgetEntityAttack::isCheckSight))).apply((Applicative)builder, ProgWidgetEntityAttack::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetEntityAttack> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetEntityAttack::useMaxActions, (StreamCodec)ByteBufCodecs.VAR_INT, ProgWidgetEntityAttack::getMaxActions, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetEntityAttack::isCheckSight, ProgWidgetEntityAttack::new);
    private EntityFilterPair<ProgWidgetEntityAttack> entityFilters;
    private int maxActions;
    private boolean useMaxActions;
    private boolean checkSight;

    public ProgWidgetEntityAttack(ProgWidget.PositionFields pos, boolean useMaxActions, int maxActions, boolean checkSight) {
        super(pos);
        this.useMaxActions = useMaxActions;
        this.maxActions = maxActions;
        this.checkSight = checkSight;
    }

    public ProgWidgetEntityAttack() {
        this(ProgWidget.PositionFields.DEFAULT, false, 1, false);
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.ENTITY_ATTACK.get();
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIAttackEntity(IDroneBase.asDrone(drone), 1.0, false, this.getEntityFilters().getFilterString(), this);
    }

    @Override
    public Goal getWidgetTargetAI(IDrone drone, IProgWidget widget) {
        return new DroneAINearestAttackableTarget(IDroneBase.asDrone(drone), this.checkSight, (ProgWidget)widget);
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ATTACK;
    }

    @Override
    public List<Entity> getValidEntities(Level world) {
        return this.getEntityFilters().getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        return this.getEntityFilters().isEntityValid(entity);
    }

    public EntityFilterPair<ProgWidgetEntityAttack> getEntityFilters() {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityAttack>(this);
        }
        return this.entityFilters;
    }

    @Override
    public Set<BlockPos> getArea(Set<BlockPos> area) {
        return ProgWidgetEntityAttack.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[2]);
    }

    public static Set<BlockPos> getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget != null) {
            ProgWidgetArea widget = whitelistWidget;
            while (widget != null) {
                widget.getArea(area, new AreaTypeBox());
                widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
            }
            widget = blacklistWidget;
            while (widget != null) {
                HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
                widget.getArea(blacklistedArea, new AreaTypeBox());
                area.removeAll(blacklistedArea);
                widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
            }
        }
        return area;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetEntityAttack(this.getPosition(), this.useMaxActions, this.maxActions, this.checkSight);
    }

    @Override
    public void setMaxActions(int maxActions) {
        this.maxActions = maxActions;
    }

    @Override
    public int getMaxActions() {
        return this.maxActions;
    }

    @Override
    public void setUseMaxActions(boolean useMaxActions) {
        this.useMaxActions = useMaxActions;
    }

    @Override
    public boolean useMaxActions() {
        return this.useMaxActions;
    }

    @Override
    public void setCheckSight(boolean checkSight) {
        this.checkSight = checkSight;
    }

    @Override
    public boolean isCheckSight() {
        return this.checkSight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetEntityAttack that = (ProgWidgetEntityAttack)o;
        return this.baseEquals(that) && this.maxActions == that.maxActions && this.useMaxActions == that.useMaxActions && this.checkSight == that.checkSight;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.maxActions, this.useMaxActions, this.checkSight);
    }
}

