/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetDroneConditionItem
extends ProgWidgetDroneCondition
implements IItemFiltering {
    public static final MapCodec<ProgWidgetDroneConditionItem> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDroneConditionItem.droneConditionParts(builder).apply((Applicative)builder, ProgWidgetDroneConditionItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDroneConditionItem> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDroneCondition.DroneConditionFields.STREAM_CODEC, ProgWidgetDroneCondition::droneConditionFields, ProgWidgetDroneConditionItem::new);

    public ProgWidgetDroneConditionItem() {
    }

    public ProgWidgetDroneConditionItem(ProgWidget.PositionFields pos, ProgWidgetDroneCondition.DroneConditionFields cond) {
        super(pos, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDroneConditionItem(this.getPosition(), this.droneConditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected int getCount(IDrone drone, IProgWidget widget) {
        if (!(widget instanceof IItemFiltering)) {
            return 0;
        }
        IItemFiltering filtering = (IItemFiltering)((Object)widget);
        int count = 0;
        for (int i = 0; i < drone.getInv().getSlots(); ++i) {
            ItemStack droneStack = drone.getInv().getStackInSlot(i);
            if (!filtering.isItemValidForFilters(droneStack)) continue;
            count += droneStack.getCount();
        }
        this.maybeRecordMeasuredVal(drone, count);
        return count;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_ITEM_INVENTORY;
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidgetDroneConditionItem.getConnectedWidgetList(this, 0, ModProgWidgetTypes.ITEM_FILTER.get()), ProgWidgetDroneConditionItem.getConnectedWidgetList(this, this.getParameters().size(), ModProgWidgetTypes.ITEM_FILTER.get()), null);
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DRONE_CONDITION_ITEM.get();
    }
}

