/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;

public class ProgWidgetBlockCondition
extends ProgWidgetCondition {
    public static final MapCodec<ProgWidgetBlockCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetBlockCondition.condParts(builder).and(builder.group((App)Codec.BOOL.optionalFieldOf("check_air", (Object)false).forGetter(p -> p.checkingForAir), (App)Codec.BOOL.optionalFieldOf("check_liquid", (Object)false).forGetter(p -> p.checkingForLiquids))).apply((Applicative)builder, ProgWidgetBlockCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetBlockCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCondition.ConditionFields.STREAM_CODEC, ProgWidgetCondition::conditionFields, (StreamCodec)ByteBufCodecs.BOOL, p -> p.checkingForAir, (StreamCodec)ByteBufCodecs.BOOL, p -> p.checkingForLiquids, ProgWidgetBlockCondition::new);
    public boolean checkingForAir;
    public boolean checkingForLiquids;

    public ProgWidgetBlockCondition() {
    }

    public ProgWidgetBlockCondition(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields inv, ProgWidgetCondition.ConditionFields cond, boolean checkingForAir, boolean checkingForLiquids) {
        super(pos, inv, cond);
        this.checkingForAir = checkingForAir;
        this.checkingForLiquids = checkingForLiquids;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetBlockCondition(this.getPosition(), this.invBaseFields().copy(), this.conditionFields(), this.checkingForAir, this.checkingForLiquids);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDrone drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                boolean ret = false;
                if (ProgWidgetBlockCondition.this.checkingForAir && this.drone.getDroneLevel().isEmptyBlock(pos)) {
                    ret = true;
                } else if (ProgWidgetBlockCondition.this.checkingForLiquids && PneumaticCraftUtils.isBlockLiquid(this.drone.getDroneLevel().getBlockState(pos).getBlock())) {
                    ret = true;
                } else if (!ProgWidgetBlockCondition.this.checkingForAir && !ProgWidgetBlockCondition.this.checkingForLiquids || ProgWidgetBlockCondition.this.getConnectedParameters()[1] != null) {
                    ret = DroneAIDig.isBlockValidForFilter((BlockGetter)this.drone.getDroneLevel(), pos, this.drone, this.progWidget);
                }
                ProgWidgetBlockCondition.this.maybeRecordMeasuredVal(this.drone, ret ? 1 : 0);
                return ret;
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_BLOCK;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_BLOCK.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetBlockCondition that = (ProgWidgetBlockCondition)o;
        return this.baseEquals(that) && this.checkingForAir == that.checkingForAir && this.checkingForLiquids == that.checkingForLiquids;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.checkingForAir, this.checkingForLiquids);
    }
}

