/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.world.entity.player.Player;

public class MicromissileDefaults
extends AuxConfigJson {
    public static final MicromissileDefaults INSTANCE = new MicromissileDefaults();
    private final Map<UUID, MicromissilesItem.Settings> defaults = new HashMap<UUID, MicromissilesItem.Settings>();

    private MicromissileDefaults() {
        super(true);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        JsonObject sub = new JsonObject();
        this.defaults.forEach((id, settings) -> MicromissilesItem.Settings.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, settings).ifSuccess(j -> sub.add(id.toString(), j)));
        json.addProperty("Description", "Stores default Micromissile settings on a per-player basis");
        json.add("defaults", (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        this.defaults.clear();
        JsonObject sub = json.getAsJsonObject("defaults");
        for (Map.Entry entry : sub.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                MicromissilesItem.Settings.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()).getAsJsonObject()).ifSuccess(settings -> this.defaults.put(UUID.fromString((String)entry.getKey()), (MicromissilesItem.Settings)settings));
                continue;
            }
            Log.warning("Invalid JSON? entry '{}' in {}", entry.getKey(), this.getConfigFilename());
        }
    }

    @Override
    public String getConfigFilename() {
        return "MicromissileDefaults";
    }

    @Override
    public IAuxConfig.Sidedness getSidedness() {
        return IAuxConfig.Sidedness.SERVER;
    }

    public void setDefaults(Player player, MicromissilesItem.Settings entry) {
        this.defaults.put(player.getUUID(), entry);
    }

    @Nonnull
    public MicromissilesItem.Settings getDefaults(Player player) {
        return this.defaults.getOrDefault(player.getUUID(), MicromissilesItem.Settings.DEFAULT);
    }
}

