/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.hacking.secstation.SimulationController;
import me.desht.pneumaticcraft.common.inventory.SecurityStationHackingMenu;
import me.desht.pneumaticcraft.common.inventory.SecurityStationMainMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SecurityStationBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<SecurityStationBlockEntity>,
MenuProvider,
IRangedTE {
    private static final List<RedstoneController.RedstoneMode<SecurityStationBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("standard.never", new ItemStack((ItemLike)Items.GUNPOWDER), te -> false), new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("securityStation.hacked", ModUpgrades.SECURITY.get().getItemStack(), SecurityStationBlockEntity::isHacked), new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("securityStation.doneRebooting", new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), te -> te.getRebootTime() <= 0));
    public static final int INV_ROWS = 7;
    public static final int INV_COLS = 5;
    private static final int INVENTORY_SIZE = 35;
    private final SecurityStationHandler inventory = new SecurityStationHandler();
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    public final RedstoneController<SecurityStationBlockEntity> rsController = new RedstoneController<SecurityStationBlockEntity>(this, REDSTONE_MODES);
    private final RangeManager rangeManager = new RangeManager(this, 0x60FF0000);
    private boolean oldRedstoneStatus;
    private boolean validNetwork;
    private ISimulationController simulationController = null;

    public SecurityStationBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.SECURITY_STATION.get(), pos, state, 4);
    }

    public void setRemoved() {
        super.setRemoved();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getSecurityStations().remove(this);
    }

    public void clearRemoved() {
        super.clearRemoved();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getSecurityStations().add(this);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.nonNullLevel().isClientSide && this.rebootTimer == 0) {
                this.hackedUsers.clear();
                NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.0f, false), this.getLevel(), this.getBlockPos());
            }
        } else if (this.simulationController != null) {
            this.simulationController.tick();
            Player hacker = this.simulationController.getHacker();
            if (!(hacker.containerMenu instanceof SecurityStationHackingMenu)) {
                if (!this.simulationController.isSimulationDone() && this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isAwake() && !this.simulationController.isJustTesting()) {
                    this.retaliate(hacker);
                }
                this.simulationController = null;
            }
        }
        if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
            this.oldRedstoneStatus = this.rsController.shouldEmit();
            this.updateNeighbours();
        }
        this.rangeManager.setRange(Math.min(2 + this.getUpgrades(ModUpgrades.RANGE.get()), 16));
    }

    private boolean isOwner(Player player) {
        return !this.sharedUsers.isEmpty() && player.getGameProfile().equals((Object)this.sharedUsers.getFirst());
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
        NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.0f, false), this.getLevel(), this.getBlockPos());
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (player.containerMenu instanceof SecurityStationMainMenu && this.isPlayerOnWhiteList((Player)player)) {
            if (tag.equals("reboot")) {
                this.rebootStation();
            } else if (tag.equals("test") && ((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue()) {
                if (this.hasValidNetwork()) {
                    this.initiateHacking(player);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.securityStation.outOfOrder"), false);
                }
            } else if (tag.startsWith("remove:") && this.isOwner((Player)player)) {
                String name = tag.split(":", 2)[1];
                this.removeTrustedUser(name);
            } else if (tag.startsWith("add:") && this.isOwner((Player)player)) {
                String name = tag.split(":", 2)[1];
                PneumaticCraftUtils.getProfileForName(player.getServer(), name).ifPresent(this::addTrustedUser);
            }
        } else if (player.containerMenu instanceof SecurityStationHackingMenu && this.isPlayerHacking((Player)player)) {
            if (tag.equals("end_test") && this.simulationController.isJustTesting()) {
                player.openMenu((MenuProvider)this, this.getBlockPos());
            } else if (tag.startsWith("nuke:")) {
                this.tryNukeVirus(tag, (Player)player);
            } else if (tag.equals("stop_worm")) {
                this.tryStopWorm((Player)player);
            } else if (tag.startsWith("fortify:")) {
                this.tryFortify(tag, (Player)player);
            } else if (tag.startsWith("hack:")) {
                this.tryHack(tag, (Player)player);
            }
        }
        this.sendDescriptionPacket();
    }

    private boolean isPlayerHacking(Player player) {
        return this.simulationController != null && this.simulationController.getHacker().isAlive() && this.simulationController.getHacker().equals((Object)player);
    }

    private void tryHack(String tag, Player player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation playerSim = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER);
            HackSimulation.Node node = playerSim.getNodeAt(nodePos);
            if (node != null && !node.isHacked() && playerSim.getHackedNeighbour(nodePos) >= 0) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).startHack(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ {}: ignoring bad message {} from {}", PneumaticCraftUtils.posToString(this.worldPosition), tag, player.getGameProfile().getName());
        }
    }

    private void tryFortify(String tag, Player player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation.Node node = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).getNodeAt(nodePos);
            if (node != null && node.isHacked()) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).fortify(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ {}: ignoring bad message {} from {}", PneumaticCraftUtils.posToString(this.worldPosition), tag, player.getGameProfile().getName());
        }
    }

    private void tryStopWorm(Player player) {
        if (!this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
            if (PneumaticCraftUtils.consumeInventoryItem(player.getInventory(), (Item)ModItems.STOP_WORM.get())) {
                int r = 80 + this.nonNullLevel().random.nextInt(40);
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).applyStopWorm(r);
            } else {
                player.kill();
            }
        }
    }

    private void tryNukeVirus(String tag, Player player) {
        try {
            if (PneumaticCraftUtils.consumeInventoryItem(player.getInventory(), (Item)ModItems.NUKE_VIRUS.get())) {
                int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).initiateNukeVirus(nodePos);
            } else {
                player.kill();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ {}: ignoring bad message {}} from {}}", PneumaticCraftUtils.posToString(this.worldPosition), tag, player.getGameProfile().getName());
        }
    }

    private HackingContainerProvider getHackingContainerProvider() {
        return new HackingContainerProvider();
    }

    public void addTrustedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private void removeTrustedUser(String name) {
        this.sharedUsers.removeIf(prof -> name.equals(prof.getName()));
        this.sendDescriptionPacket();
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean isHacked() {
        return !this.hackedUsers.isEmpty();
    }

    public BoundingBox getSecurityCoverage() {
        return this.rangeManager.getExtents();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.rebootTimer = tag.getInt("startupTimer");
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        this.checkForNetworkValidity();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("startupTimer", this.rebootTimer);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        tag.put("SharedUsers", (Tag)this.toNBTList(this.sharedUsers));
        tag.put("HackedUsers", (Tag)this.toNBTList(this.hackedUsers));
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        this.sharedUsers.clear();
        this.sharedUsers.addAll(this.fromNBTList(tag.getList("SharedUsers", 10)));
        this.hackedUsers.clear();
        this.hackedUsers.addAll(this.fromNBTList(tag.getList("HackedUsers", 10)));
    }

    private ListTag toNBTList(Collection<GameProfile> profiles) {
        ListTag res = new ListTag();
        for (GameProfile profile : profiles) {
            res.add((Object)((Tag)Util.make((Object)new CompoundTag(), t -> {
                t.putString("name", profile.getName());
                t.putString("uuid", profile.getId().toString());
            })));
        }
        return res;
    }

    private Collection<GameProfile> fromNBTList(ListTag list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tagCompound = list.getCompound(i);
            builder.add((Object)new GameProfile(UUID.fromString(tagCompound.getString("uuid")), tagCompound.getString("name")));
        }
        return builder.build();
    }

    public boolean doesAllowPlayer(Player player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean doesAllowPlayer(UUID playerID) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(playerID) || this.hasPlayerHacked(playerID);
    }

    private boolean isPlayerOnWhiteList(UUID playerID) {
        return this.sharedUsers.stream().anyMatch(p -> p.getId().equals(playerID));
    }

    private boolean hasPlayerHacked(UUID playerID) {
        return this.hackedUsers.stream().anyMatch(p -> p.getId().equals(playerID));
    }

    public boolean isPlayerOnWhiteList(Player player) {
        return this.sharedUsers.contains(player.getGameProfile());
    }

    public boolean hasPlayerHacked(Player player) {
        return this.hackedUsers.contains(player.getGameProfile());
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.inventory.getStackInSlot(firstSlot).isEmpty() || this.inventory.getStackInSlot(secondSlot).isEmpty()) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new SecurityStationMainMenu(i, playerInventory, this.getBlockPos());
    }

    public void initiateHacking(ServerPlayer hacker) {
        if (this.simulationController != null) {
            hacker.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackInProgress", new Object[0]).withStyle(ChatFormatting.GOLD), false);
        } else {
            this.simulationController = new SimulationController(this, (Player)hacker, this.isPlayerOnWhiteList((Player)hacker));
            hacker.openMenu((MenuProvider)this.getHackingContainerProvider(), buf -> this.simulationController.toBytes((RegistryFriendlyByteBuf)buf));
        }
    }

    public int findComponent(NetworkComponentItem.NetworkComponentType type) {
        for (int i = 0; i < 35; ++i) {
            if (!NetworkComponentItem.isType(this.inventory.getStackInSlot(i), type)) continue;
            return i;
        }
        return -1;
    }

    public ISimulationController getSimulationController() {
        return this.simulationController;
    }

    public void setSimulationController(ISimulationController newController) {
        this.simulationController = newController;
    }

    public void retaliate(Player hacker) {
        hacker.hurt(PNCDamageSource.securityStation(this.getLevel()), hacker.getMaxHealth() - 0.5f);
        hacker.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100));
        hacker.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
        hacker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 300, 3));
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            Optional<NetworkComponentItem.NetworkComponentType> type;
            if (this.inventory.getStackInSlot(i).isEmpty() || (type = NetworkComponentItem.getType(this.inventory.getStackInSlot(i))).isEmpty()) continue;
            switch (type.get()) {
                case DIAGNOSTIC_SUBROUTINE: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case NETWORK_IO_PORT: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case NETWORK_REGISTRY: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        double n = 1.0 - Math.pow(0.7, this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) + 1);
        return Mth.clamp((int)((int)(n * 100.0)), (int)0, (int)100);
    }

    public int getSecurityLevel() {
        return Math.min(64, 1 + this.getUpgrades(ModUpgrades.SECURITY.get()));
    }

    @Override
    public boolean isGuiUseableByPlayer(Player par1EntityPlayer) {
        return this.nonNullLevel().getBlockEntity(this.getBlockPos()) == this;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public RedstoneController<SecurityStationBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public static int getProtectingSecurityStations(Player player, BlockPos pos, boolean isPlacingSecurityStation) {
        return (int)SecurityStationBlockEntity.getSecurityStations(player.getCommandSenderWorld(), pos, isPlacingSecurityStation).filter(teSS -> !teSS.doesAllowPlayer(player)).count();
    }

    public static boolean isProtectedFromPlayer(Player player, BlockPos pos, boolean isPlacingSecurityStation) {
        return SecurityStationBlockEntity.getSecurityStations(player.getCommandSenderWorld(), pos, isPlacingSecurityStation).anyMatch(teSS -> !teSS.doesAllowPlayer(player));
    }

    public static boolean isProtectedFromPlayer(UUID playerId, Level level, BlockPos pos, boolean isPlacingSecurityStation) {
        return SecurityStationBlockEntity.getSecurityStations(level, pos, isPlacingSecurityStation).anyMatch(teSS -> !teSS.doesAllowPlayer(playerId));
    }

    static Stream<SecurityStationBlockEntity> getSecurityStations(Level level, BlockPos pos, boolean isPlacingSecurityStation) {
        return GlobalBlockEntityCacheManager.getInstance((LevelAccessor)level).getSecurityStations().stream().filter(station -> SecurityStationBlockEntity.isValidAndInRange(level, pos, isPlacingSecurityStation, station));
    }

    private static boolean isValidAndInRange(Level world, BlockPos pos, boolean isPlacingSecurityStation, SecurityStationBlockEntity teSS) {
        if (!teSS.isRemoved() && teSS.nonNullLevel().dimension().compareTo(world.dimension()) == 0 && teSS.hasValidNetwork()) {
            BoundingBox boundingBox = teSS.getSecurityCoverage();
            if (isPlacingSecurityStation) {
                boundingBox = boundingBox.inflatedBy(16);
            }
            return boundingBox.minX() <= pos.getX() && boundingBox.maxX() >= pos.getX() && boundingBox.minY() <= pos.getY() && boundingBox.maxY() >= pos.getY() && boundingBox.minZ() <= pos.getZ() && boundingBox.maxZ() >= pos.getZ();
        }
        return false;
    }

    private static boolean isPlayerExempt(Player player) {
        return player.isCreative() && (Boolean)ConfigHelper.common().machines.securityStationCreativePlayersExempt.get() != false || player.hasPermissions(2);
    }

    private class SecurityStationHandler
    extends BaseItemStackHandler {
        private SecurityStationHandler() {
            super(SecurityStationBlockEntity.this, 35);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return NetworkComponentItem.getType(stack).map(NetworkComponentItem.NetworkComponentType::isSecStationComponent).orElse(false);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SecurityStationBlockEntity.this.checkForNetworkValidity();
        }
    }

    private class HackingContainerProvider
    implements MenuProvider {
        private HackingContainerProvider() {
        }

        public Component getDisplayName() {
            return SecurityStationBlockEntity.this.getName().plainCopy().append(" ").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.hacking", new Object[0]));
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return new SecurityStationHackingMenu(windowId, playerInventory, SecurityStationBlockEntity.this.getBlockPos());
        }
    }

    public static enum EnumNetworkValidityProblem implements ITranslatableEnum
    {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.security_station." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
            if (!Listener.handleInteraction((PlayerInteractEvent)event)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
            if (!Listener.handleInteraction((PlayerInteractEvent)event)) {
                event.setCanceled(true);
            }
        }

        private static boolean handleInteraction(PlayerInteractEvent event) {
            ServerPlayer player;
            block7: {
                block6: {
                    Player player2 = event.getEntity();
                    if (!(player2 instanceof ServerPlayer)) break block6;
                    player = (ServerPlayer)player2;
                    if (event.getLevel().isLoaded(event.getPos())) break block7;
                }
                return true;
            }
            ItemStack heldItem = player.getItemInHand(event.getHand());
            BlockState interactedBlockState = event.getLevel().getBlockState(event.getPos());
            Block interactedBlock = interactedBlockState.getBlock();
            if (interactedBlock != ModBlocks.SECURITY_STATION.get() || event instanceof PlayerInteractEvent.LeftClickBlock) {
                BlockItem bi;
                boolean tryingToPlaceSecurityStation;
                Item item = heldItem.getItem();
                boolean bl = tryingToPlaceSecurityStation = item instanceof BlockItem && (bi = (BlockItem)item).getBlock() == ModBlocks.SECURITY_STATION.get();
                if (SecurityStationBlockEntity.isProtectedFromPlayer((Player)player, event.getPos(), tryingToPlaceSecurityStation)) {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).withStyle(ChatFormatting.RED), true);
                    if (heldItem.getItem() instanceof BlockItem) {
                        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.getInventory().selected, heldItem));
                    }
                    return false;
                }
            }
            return true;
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!event.getLevel().isClientSide() && !SecurityStationBlockEntity.isPlayerExempt(player)) {
                    if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                        for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                            if (!Listener.isPlacementPrevented(event, player, snapshot.getPos())) continue;
                            return;
                        }
                    } else {
                        Listener.isPlacementPrevented(event, player, event.getPos());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (!SecurityStationBlockEntity.isPlayerExempt(player) && SecurityStationBlockEntity.isProtectedFromPlayer(player, event.getPos(), false)) {
                event.setCanceled(true);
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).withStyle(ChatFormatting.RED), true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockExplode(ExplosionEvent.Start event) {
            Player player = Listener.getPlayerForExplosion((ExplosionEvent)event);
            if (player != null && !SecurityStationBlockEntity.isPlayerExempt(player) && !event.getLevel().isClientSide) {
                event.getExplosion().getToBlow().removeIf(pos -> SecurityStationBlockEntity.isProtectedFromPlayer(player, pos, false));
            }
        }

        private static boolean isPlacementPrevented(BlockEvent.EntityPlaceEvent event, Player player, BlockPos pos) {
            boolean tryingToPlaceSecurityStation;
            boolean bl = tryingToPlaceSecurityStation = event.getPlacedBlock().getBlock() == ModBlocks.SECURITY_STATION.get();
            if (SecurityStationBlockEntity.isProtectedFromPlayer(player, pos, tryingToPlaceSecurityStation)) {
                event.setCanceled(true);
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).withStyle(ChatFormatting.RED), true);
                return true;
            }
            return false;
        }

        private static Player getPlayerForExplosion(ExplosionEvent event) {
            LivingEntity entity = event.getExplosion().getIndirectSourceEntity();
            return entity instanceof Player ? (Player)entity : null;
        }

        @SubscribeEvent
        public static void onContainerClose(PlayerContainerEvent.Close event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player = event.getContainer();
                if (player instanceof SecurityStationHackingMenu) {
                    MinecraftServer server;
                    SecurityStationHackingMenu menu = (SecurityStationHackingMenu)player;
                    SecurityStationBlockEntity teSS = (SecurityStationBlockEntity)menu.blockEntity;
                    if (teSS.getSimulationController() != null && teSS.getSimulationController().isJustTesting() && (server = player2.getServer()) != null) {
                        server.tell((Runnable)new TickTask(server.getTickCount(), () -> player2.openMenu((MenuProvider)teSS, teSS.getBlockPos())));
                    }
                }
            }
        }
    }
}

