/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.heat;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.heat.CompressedIronBlockEntity;
import me.desht.pneumaticcraft.common.inventory.CreativeCompressedIronBlockMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;

public class CreativeCompressedIronBlockEntity
extends CompressedIronBlockEntity
implements MenuProvider {
    @GuiSynced
    public int targetTemperature = -1;

    public CreativeCompressedIronBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CREATIVE_COMPRESSED_IRON_BLOCK.get(), pos, state);
        this.heatExchanger.setThermalCapacity(1000000.0);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.targetTemperature < 0) {
            this.targetTemperature = (int)this.heatExchanger.getAmbientTemperature();
        }
        this.heatExchanger.setTemperature(this.targetTemperature);
    }

    @Override
    public boolean shouldShowGuiHeatTab() {
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("targetTemperature", this.targetTemperature);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.targetTemperature = tag.getInt("targetTemperature");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        try {
            this.targetTemperature += (int)Float.parseFloat(tag);
            this.targetTemperature = Mth.clamp((int)this.targetTemperature, (int)0, (int)2273);
            this.setChanged();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setTargetTemperature(int temp) {
        this.targetTemperature = temp;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new CreativeCompressedIronBlockMenu(windowId, playerInventory, this.getBlockPos());
    }
}

