/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.compressor.AirCompressorBlockEntity;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.AdvancedAirCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedAirCompressorBlockEntity
extends AirCompressorBlockEntity
implements IHeatExchangingTE {
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();

    public AdvancedAirCompressorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ADVANCED_AIR_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 10000);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    @Override
    protected void addHeatForAir(int air) {
        this.heatExchanger.addHeat((double)air / 20.0);
    }

    @Override
    public int getBaseProduction() {
        return 50;
    }

    @Override
    public int getHeatEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new AdvancedAirCompressorMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

