/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MovingSoundAirLeak
extends AbstractTickableSoundInstance {
    private final BlockEntity te;
    private final Direction dir;
    private float targetPitch;

    MovingSoundAirLeak(BlockEntity te, Direction dir) {
        super((SoundEvent)ModSounds.LEAKING_GAS.get(), SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.te = te;
        this.dir = dir;
        this.x = te.getBlockPos().getX();
        this.y = te.getBlockPos().getY();
        this.z = te.getBlockPos().getZ();
        this.looping = true;
        this.delay = 0;
        this.targetPitch = 1.0f;
        this.volume = ((Double)ConfigHelper.client().sound.airLeakVolume.get()).floatValue();
    }

    public void tick() {
        PNCCapabilities.getAirHandler(this.te, this.dir).ifPresent(handler -> {
            this.targetPitch = Mth.clamp((float)(1.0f + (handler.getPressure() - 3.0f) / 20.0f), (float)0.8f, (float)1.6f);
            if (this.pitch > this.targetPitch) {
                this.pitch -= 0.005f;
            } else if (this.pitch < this.targetPitch) {
                this.pitch += 0.005f;
            }
        });
    }

    public boolean isStopped() {
        return this.te.isRemoved() || PNCCapabilities.getAirHandler(this.te, this.dir).map(h -> h.getSideLeaking() == null || h.getAir() == 0).orElse(true) != false;
    }
}

