/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.entity.hopper.LiquidHopperBlockEntity;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class RenderLiquidHopper
extends AbstractFluidTER<LiquidHopperBlockEntity> {
    private static final AABB[] BOUNDS = new AABB[6];

    public RenderLiquidHopper(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    Collection<TankRenderInfo> getTanksToRender(LiquidHopperBlockEntity te) {
        return ImmutableList.of((Object)new TankRenderInfo(te.getTank(), BOUNDS[te.getInputDirection().get3DDataValue()], new Direction[0]));
    }

    static {
        RenderLiquidHopper.BOUNDS[Direction.DOWN.get3DDataValue()] = new AABB(0.031875, 0.031875, 0.031875, 0.968125, 0.311875, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.UP.get3DDataValue()] = new AABB(0.031875, 0.688125, 0.031875, 0.968125, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.NORTH.get3DDataValue()] = new AABB(0.031875, 0.031875, 0.031875, 0.968125, 0.968125, 0.311875);
        RenderLiquidHopper.BOUNDS[Direction.SOUTH.get3DDataValue()] = new AABB(0.031875, 0.031875, 0.718125, 0.968125, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.WEST.get3DDataValue()] = new AABB(0.031875, 0.031875, 0.031875, 0.311875, 0.968125, 0.968125);
        RenderLiquidHopper.BOUNDS[Direction.EAST.get3DDataValue()] = new AABB(0.688125, 0.031875, 0.031875, 0.968125, 0.968125, 0.968125);
    }

    public static class ItemRenderInfoProvider
    implements IFluidItemRenderInfoProvider {
        private static final AABB BOUNDS_UP = BOUNDS[Direction.UP.get3DDataValue()];

        @Override
        public List<TankRenderInfo> getTanksToRender(ItemStack stack) {
            IFluidHandler h = (IFluidHandler)IOHelper.getFluidHandlerForItem(stack).orElseThrow(RuntimeException::new);
            return List.of(new TankRenderInfo(h.getFluidInTank(0), h.getTankCapacity(0), BOUNDS_UP, new Direction[0]).without(Direction.DOWN));
        }
    }
}

