/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.utility.UniversalSensorBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class UniversalSensorRenderer
extends AbstractBlockEntityModelRenderer<UniversalSensorBlockEntity> {
    private final ModelPart part1;
    private final ModelPart part2;
    private final ModelPart part3;
    private final ModelPart part4;
    private final ModelPart part5;
    private final ModelPart part6;
    private final ModelPart part7;
    private final ModelPart part8;
    private final ModelPart part9;
    private final ModelPart part10;
    private final ModelPart part11;
    private final ModelPart part12;
    private final ModelPart part13;
    private final ModelPart part14;
    private final ModelPart part15;
    private static final String PART1 = "part1";
    private static final String PART2 = "part2";
    private static final String PART3 = "part3";
    private static final String PART4 = "part4";
    private static final String PART5 = "part5";
    private static final String PART6 = "part6";
    private static final String PART7 = "part7";
    private static final String PART8 = "part8";
    private static final String PART8_R1 = "part8_r1";
    private static final String PART9 = "part9";
    private static final String PART9_R1 = "part9_r1";
    private static final String PART10 = "part10";
    private static final String PART10_R1 = "part10_r1";
    private static final String PART11 = "part11";
    private static final String PART11_R1 = "part11_r1";
    private static final String PART12 = "part12";
    private static final String PART12_R1 = "part12_r1";
    private static final String PART13 = "part13";
    private static final String PART13_R1 = "part13_r1";
    private static final String PART14 = "part14";
    private static final String PART14_R1 = "part14_r1";
    private static final String PART15 = "part15";
    private static final String PART15_R1 = "part15_r1";

    public UniversalSensorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.UNIVERSAL_SENSOR);
        this.part1 = root.getChild(PART1);
        this.part2 = root.getChild(PART2);
        this.part3 = root.getChild(PART3);
        this.part4 = root.getChild(PART4);
        this.part5 = root.getChild(PART5);
        this.part6 = root.getChild(PART6);
        this.part7 = root.getChild(PART7);
        this.part8 = root.getChild(PART8);
        this.part9 = root.getChild(PART9);
        this.part10 = root.getChild(PART10);
        this.part11 = root.getChild(PART11);
        this.part12 = root.getChild(PART12);
        this.part13 = root.getChild(PART13);
        this.part14 = root.getChild(PART14);
        this.part15 = root.getChild(PART15);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(PART1, CubeListBuilder.create().texOffs(0, 0).addBox("part1_0", -2.0f, 0.0f, -2.0f, 4, 1, 4, 0, 0).mirror(), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(PART2, CubeListBuilder.create().texOffs(0, 9).addBox("part2_0", -3.0f, 4.0f, 0.5f, 1, 3, 3, 0, 9).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        partdefinition.addOrReplaceChild(PART3, CubeListBuilder.create().texOffs(16, 3).addBox("part3_0", -2.0f, 1.25f, -0.5f, 6, 1, 1, 16, 3).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        partdefinition.addOrReplaceChild(PART4, CubeListBuilder.create().texOffs(16, 0).addBox("part4_0", 3.25f, 1.25f, -1.0f, 1, 1, 2, 16, 0).mirror(), PartPose.offset((float)0.0f, (float)10.2f, (float)0.0f));
        partdefinition.addOrReplaceChild(PART5, CubeListBuilder.create().texOffs(0, 5).addBox("part5_0", -3.0f, 3.0f, 0.5f, 1, 1, 3, 0, 5).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        partdefinition.addOrReplaceChild(PART6, CubeListBuilder.create().texOffs(0, 5).addBox("part6_0", -3.0f, -2.0f, 0.5f, 1, 1, 3, 0, 5).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        partdefinition.addOrReplaceChild(PART7, CubeListBuilder.create().texOffs(18, 9).addBox("part7_0", -2.5f, -1.0f, 0.5f, 0, 4, 3, 18, 9).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        PartDefinition part8 = partdefinition.addOrReplaceChild(PART8, CubeListBuilder.create().texOffs(20, 6), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part8.addOrReplaceChild(PART8_R1, CubeListBuilder.create().texOffs(20, 6).addBox("part8_r1_0", 0.0f, -0.5f, 0.0f, 1, 1, 5, 20, 6).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)3.5f, (float)3.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition part9 = partdefinition.addOrReplaceChild(PART9, CubeListBuilder.create().texOffs(20, 6), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part9.addOrReplaceChild(PART9_R1, CubeListBuilder.create().texOffs(20, 6).addBox("part9_r1_0", 0.0f, -0.5f, 0.0f, 1, 1, 5, 20, 6).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)-1.5f, (float)3.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition part10 = partdefinition.addOrReplaceChild(PART10, CubeListBuilder.create().texOffs(15, 2), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part10.addOrReplaceChild(PART10_R1, CubeListBuilder.create().texOffs(15, 2).addBox("part10_r1_0", 0.0f, -0.5f, 0.0f, 0, 4, 5, 15, 2).mirror(), PartPose.offsetAndRotation((float)-2.5f, (float)-0.5f, (float)3.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition part11 = partdefinition.addOrReplaceChild(PART11, CubeListBuilder.create().texOffs(8, 6), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part11.addOrReplaceChild(PART11_R1, CubeListBuilder.create().texOffs(8, 6).addBox("part11_r1_0", 0.0f, -0.5f, -5.0f, 1, 1, 5, 8, 6).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)3.5f, (float)-3.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition part12 = partdefinition.addOrReplaceChild(PART12, CubeListBuilder.create().texOffs(8, 6), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part12.addOrReplaceChild(PART12_R1, CubeListBuilder.create().texOffs(8, 6).addBox("part12_r1_0", 0.0f, -0.5f, -5.0f, 1, 1, 5, 8, 6).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)-1.5f, (float)-3.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition part13 = partdefinition.addOrReplaceChild(PART13, CubeListBuilder.create().texOffs(8, 7), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part13.addOrReplaceChild(PART13_R1, CubeListBuilder.create().texOffs(8, 7).addBox("part13_r1_0", 0.0f, -0.5f, -5.0f, 0, 4, 5, 8, 7).mirror(), PartPose.offsetAndRotation((float)-2.5f, (float)-0.5f, (float)-3.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition part14 = partdefinition.addOrReplaceChild(PART14, CubeListBuilder.create().texOffs(28, 12), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part14.addOrReplaceChild(PART14_R1, CubeListBuilder.create().texOffs(28, 12).addBox("part14_r1_0", 0.0f, -3.5f, 4.0f, 1, 4, 1, 28, 12).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)2.5f, (float)3.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition part15 = partdefinition.addOrReplaceChild(PART15, CubeListBuilder.create().texOffs(28, 12), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2269f));
        part15.addOrReplaceChild(PART15_R1, CubeListBuilder.create().texOffs(28, 12).addBox("part15_r1_0", 0.0f, -3.5f, -5.0f, 1, 4, 1, 28, 12).mirror(), PartPose.offsetAndRotation((float)-3.0f, (float)2.5f, (float)-3.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    @Override
    public void renderModel(UniversalSensorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_UNIVERSAL_SENSOR));
        float rotation = Mth.lerp((float)partialTicks, (float)te.oldDishRotation, (float)te.dishRotation);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
        this.part1.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part3.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part4.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part5.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part6.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part7.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part8.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part9.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part10.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part11.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part12.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part13.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part14.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.part15.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }

    public AABB getRenderBoundingBox(UniversalSensorBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

