/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.render.area.AreaRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.item.CamoApplicatorItem;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public enum AreaRenderManager {
    INSTANCE;

    private static final int MAX_DISPLAYED_POS = 15000;
    private final Map<BlockPos, AreaRenderer> showHandlers = new HashMap<BlockPos, AreaRenderer>();
    private Level level;
    private DroneDebugClientHandler droneDebugger;
    private List<AreaRenderer> cachedPositionProviderShowers = new ArrayList<AreaRenderer>();
    private AreaRenderer camoPositionShower;
    private AreaRenderer jackhammerPositionShower;
    private LastJackhammerDetails lastJackhammerDetails = new LastJackhammerDetails(BlockPos.ZERO, null, null, false);
    private BlockPos lastPlayerPos;
    private int lastItemHashCode = 0;

    public static AreaRenderManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Player player = ClientUtils.getClientPlayer();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        PoseStack matrixStack = event.getPoseStack();
        matrixStack.pushPose();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        for (AreaRenderer handler : this.showHandlers.values()) {
            handler.render(matrixStack, (MultiBufferSource)buffer);
        }
        this.maybeRenderPositionProvider(matrixStack, buffer, player);
        this.maybeRenderCamo(matrixStack, buffer, player);
        this.maybeRenderDroneDebug(matrixStack, buffer, player);
        this.maybeRenderAreaTool(matrixStack, buffer, player);
        this.maybeRenderJackhammer(matrixStack, buffer, player);
        this.maybeRenderCoordinateTracker(matrixStack, buffer, player, event.getPartialTick());
        matrixStack.popPose();
    }

    @SubscribeEvent
    public void tickEnd(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            if (player.level() != this.level) {
                this.level = player.level();
                this.showHandlers.clear();
            } else {
                this.showHandlers.keySet().removeIf(arg_0 -> this.lambda$tickEnd$0((Player)player, arg_0));
            }
        } else if (this.level != null) {
            this.level = null;
            this.showHandlers.clear();
            this.cachedPositionProviderShowers.clear();
        }
    }

    private void maybeRenderCoordinateTracker(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player, DeltaTracker partialTicks) {
        BlockPos pos;
        CoordTrackerHandler handler = CommonUpgradeHandlers.coordTrackerHandler;
        if (CommonArmorHandler.getHandlerForPlayer().upgradeUsable(handler, true) && (pos = ClientArmorRegistry.getInstance().getClientHandler(handler, CoordTrackClientHandler.class).getTrackedPos()) != null) {
            float progress = ((float)(player.level().getGameTime() % 20L) + partialTicks.getGameTimeDeltaPartialTick(false)) / 20.0f;
            float g = progress < 0.5f ? progress + 0.5f : 1.5f - progress;
            int col = 0xA00000FF | (int)(g * 255.0f) << 8;
            Vec3 targetVec = Vec3.atCenterOf((Vec3i)pos);
            float size = ClientUtils.calculateViewScaling(targetVec);
            float textSize = size * 0.02f;
            matrixStack.pushPose();
            matrixStack.translate(targetVec.x(), targetVec.y(), targetVec.z());
            matrixStack.scale(textSize, textSize, textSize);
            RenderUtils.rotateToPlayerFacing(matrixStack);
            RenderUtils.renderString3d((Component)Component.literal((String)PneumaticCraftUtils.posToString(pos)), 0.0f, 0.0f, -1, matrixStack, (MultiBufferSource)buffer, true, true);
            matrixStack.popPose();
            AreaRenderer.builder().withColor(col).xray().withSize(size / 2.0f).build(pos).render(matrixStack, (MultiBufferSource)buffer);
        }
    }

    private void maybeRenderAreaTool(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.getItem() instanceof GPSAreaToolItem) {
            GPSAreaToolItem.getGPSLocation(player, curItem, 0).ifPresent(pos -> AreaRenderer.builder().withColor(-2130747296).xray().build((BlockPos)pos).render(matrixStack, (MultiBufferSource)buffer));
            GPSAreaToolItem.getGPSLocation(player, curItem, 1).ifPresent(pos -> AreaRenderer.builder().withColor(-2141126816).xray().build((BlockPos)pos).render(matrixStack, (MultiBufferSource)buffer));
        }
    }

    private void maybeRenderDroneDebug(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() == ModItems.PNEUMATIC_HELMET.get()) {
            if (this.droneDebugger == null) {
                this.droneDebugger = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.droneDebugHandler, DroneDebugClientHandler.class);
            }
            Set<BlockPos> posSet = this.droneDebugger.getShowingPositions();
            Set<BlockPos> areaSet = this.droneDebugger.getShownArea();
            AreaRenderer.builder().withColor(-1862336512).xray().build(posSet).render(matrixStack, (MultiBufferSource)buffer);
            AreaRenderer.builder().withColor(1078001568).xray().build(areaSet).render(matrixStack, (MultiBufferSource)buffer);
        }
    }

    private ItemStack getHeldPositionProvider(Player player) {
        if (player.getMainHandItem().getItem() instanceof IPositionProvider) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof IPositionProvider) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    private void maybeRenderPositionProvider(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        Item item = curItem.getItem();
        if (item instanceof IPositionProvider) {
            IPositionProvider positionProvider = (IPositionProvider)item;
            int thisHash = ItemStack.hashItemAndComponents((ItemStack)curItem);
            if (thisHash != this.lastItemHashCode) {
                this.lastItemHashCode = thisHash;
                List<BlockPos> posList = positionProvider.getStoredPositions(player.getUUID(), curItem);
                if (posList.size() > 15000) {
                    posList = posList.stream().sorted(Comparator.comparingDouble(blockPos -> blockPos.distSqr((Vec3i)player.blockPosition()))).toList();
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.gps_tool.culledRenderArea", posList.size()).withStyle(ChatFormatting.GOLD), false);
                }
                Int2ObjectOpenHashMap colorsToPositions = new Int2ObjectOpenHashMap();
                int n = Math.min(posList.size(), 15000);
                for (int i = 0; i < n; ++i) {
                    int renderColor = positionProvider.getRenderColor(i);
                    if (posList.get(i) == null || renderColor == 0) continue;
                    ((Set)colorsToPositions.computeIfAbsent(renderColor, k -> new HashSet())).add(posList.get(i));
                }
                this.cachedPositionProviderShowers = new ArrayList<AreaRenderer>(colorsToPositions.size());
                colorsToPositions.int2ObjectEntrySet().forEach(entry -> {
                    AreaRenderer.Builder builder = AreaRenderer.builder().withColor(entry.getIntKey());
                    if (positionProvider.disableDepthTest()) {
                        builder.xray();
                    }
                    this.cachedPositionProviderShowers.add(builder.build((Set)entry.getValue()));
                });
            }
            this.cachedPositionProviderShowers.forEach(renderer -> renderer.render(matrixStack, (MultiBufferSource)buffer));
        }
    }

    private void maybeRenderCamo(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        if (!(player.getMainHandItem().getItem() instanceof CamoApplicatorItem)) {
            return;
        }
        if (this.lastPlayerPos == null || this.camoPositionShower == null || player.distanceToSqr((double)this.lastPlayerPos.getX(), (double)this.lastPlayerPos.getY(), (double)this.lastPlayerPos.getZ()) > 9.0) {
            this.lastPlayerPos = player.blockPosition();
            Set<BlockPos> s = this.getNearbyBlockEntities().stream().filter(te -> te instanceof CamouflageableBlockEntity && te.getBlockPos().distSqr((Vec3i)this.lastPlayerPos) < 144.0).map(BlockEntity::getBlockPos).collect(Collectors.toSet());
            this.camoPositionShower = AreaRenderer.builder().withColor(1082163455).withSize(0.75f).xray().drawShapes().build(s);
        }
        if (this.camoPositionShower != null) {
            this.camoPositionShower.render(matrixStack, (MultiBufferSource)buffer);
        }
    }

    private Collection<BlockEntity> getNearbyBlockEntities() {
        ArrayList<BlockEntity> res = new ArrayList<BlockEntity>();
        BlockPos pos = ClientUtils.getClientPlayer().blockPosition();
        for (int x = pos.getX() - 16; x <= pos.getX() + 16; x += 16) {
            for (int z = pos.getZ() - 16; z <= pos.getZ() + 16; z += 16) {
                ChunkPos cp = new ChunkPos(pos);
                res.addAll(ClientUtils.getClientLevel().getChunk(cp.x, cp.z).getBlockEntities().values());
            }
        }
        return res;
    }

    private void maybeRenderJackhammer(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        if (this.level == null || !(player.getMainHandItem().getItem() instanceof JackHammerItem) || !(Minecraft.getInstance().hitResult instanceof BlockHitResult)) {
            return;
        }
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(player.getMainHandItem());
        if (digMode == JackHammerItem.DigMode.MODE_1X1) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)Minecraft.getInstance().hitResult;
        if (!this.level.isLoaded(brtr.getBlockPos()) || this.level.getBlockState(brtr.getBlockPos()).isAir()) {
            return;
        }
        if (!this.lastJackhammerDetails.matches(brtr.getBlockPos(), brtr.getDirection(), digMode, player.isShiftKeyDown())) {
            Set<BlockPos> posSet;
            BlockState state = this.level.getBlockState(brtr.getBlockPos());
            Set<BlockPos> set = posSet = this.level.getBlockEntity(brtr.getBlockPos()) == null && !(state.getBlock() instanceof LiquidBlock) ? JackHammerItem.getBreakPositions(this.level, brtr.getBlockPos(), brtr.getDirection(), player, digMode) : Collections.emptySet();
            if (!posSet.isEmpty()) {
                posSet.add(brtr.getBlockPos());
            }
            AreaRenderer.Builder b = AreaRenderer.builder().withColor(0x20FFFFFF).withSize(1.01f).disableWriteMask();
            if (state.getShape((BlockGetter)this.level, brtr.getBlockPos()) != Shapes.block()) {
                b = b.drawShapes();
            }
            this.jackhammerPositionShower = b.build(posSet);
            this.lastJackhammerDetails = new LastJackhammerDetails(brtr.getBlockPos(), brtr.getDirection(), digMode, player.isShiftKeyDown());
        }
        this.jackhammerPositionShower.render(matrixStack, (MultiBufferSource)buffer);
    }

    public AreaRenderer showArea(BlockPos[] area, int color, BlockEntity areaShower) {
        return this.showArea(new HashSet<BlockPos>(Arrays.asList(area)), color, areaShower);
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, BlockEntity areaShower, boolean depth) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaRenderer.Builder builder = AreaRenderer.builder().withColor(color);
        if (depth) {
            builder.xray();
        }
        AreaRenderer handler = builder.build(area);
        this.showHandlers.put(new BlockPos(areaShower.getBlockPos().getX(), areaShower.getBlockPos().getY(), areaShower.getBlockPos().getZ()), handler);
        return handler;
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, BlockEntity areaShower) {
        return this.showArea(area, color, areaShower, true);
    }

    public boolean isShowing(BlockEntity te) {
        return this.showHandlers.containsKey(new BlockPos(te.getBlockPos().getX(), te.getBlockPos().getY(), te.getBlockPos().getZ()));
    }

    public void removeHandlers(BlockEntity te) {
        this.showHandlers.remove(new BlockPos(te.getBlockPos().getX(), te.getBlockPos().getY(), te.getBlockPos().getZ()));
    }

    public void clearPosProviderCache() {
        this.lastItemHashCode = 0;
    }

    private /* synthetic */ boolean lambda$tickEnd$0(Player player, BlockPos pos) {
        return PneumaticCraftUtils.distBetweenSq(pos, player.blockPosition()) < 1024.0 && this.level.isEmptyBlock(pos);
    }

    private record LastJackhammerDetails(BlockPos pos, Direction face, JackHammerItem.DigMode digMode, boolean shift) {
        private boolean matches(BlockPos pos, Direction face, JackHammerItem.DigMode digMode, boolean shift) {
            return face == this.face && digMode == this.digMode && pos.equals((Object)this.pos) && shift == this.shift;
        }
    }
}

