/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ProgressBarRenderer {
    public static void render3d(PoseStack poseStack, MultiBufferSource buffer, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.lerp((float)(progress / 100.0f), (float)minX, (float)maxX);
        RenderUtils.renderWithTypeAndFinish(poseStack, buffer, ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH, (posMat, builder) -> {
            builder.addVertex(posMat, minX, minY, zLevel).setColor(f1[0], f1[1], f1[2], f1[3]).setLight(0xF000F0);
            builder.addVertex(posMat, minX, minY + (maxY - minY), zLevel).setColor(f1[0], f1[1], f1[2], f1[3]).setLight(0xF000F0);
            builder.addVertex(posMat, x, minY + (maxY - minY), zLevel).setColor(f2[0], f2[1], f2[2], f2[3]).setLight(0xF000F0);
            builder.addVertex(posMat, x, minY, zLevel).setColor(f2[0], f2[1], f2[2], f2[3]).setLight(0xF000F0);
        });
        Matrix3f normal = poseStack.last().normal();
        RenderUtils.renderWithTypeAndFinish(poseStack, buffer, ModRenderTypes.getLineLoops(1.5), (posMat, builder) -> {
            RenderUtils.normalLine(builder, poseStack, minX, minY, zLevel, minX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, poseStack, minX, maxY, zLevel, maxX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, poseStack, maxX, maxY, zLevel, maxX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, poseStack, maxX, minY, zLevel, minX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
        });
    }

    public static void render2d(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.lerp((float)(progress / 100.0f), (float)minX, (float)maxX);
        Matrix4f posMat = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(posMat, minX, minY, zLevel).setColor(f1[0], f1[1], f1[2], f1[3]);
        builder.addVertex(posMat, minX, minY + (maxY - minY), zLevel).setColor(f1[0], f1[1], f1[2], f1[3]);
        builder.addVertex(posMat, x, minY + (maxY - minY), zLevel).setColor(f2[0], f2[1], f2[2], f2[3]);
        builder.addVertex(posMat, x, minY, zLevel).setColor(f2[0], f2[1], f2[2], f2[3]);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.lineWidth((float)2.0f);
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(posMat, minX, minY, zLevel).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, minX, maxY, zLevel).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, maxX, maxY, zLevel).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, maxX, minY, zLevel).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private static Pair<float[], float[]> calcColors(int color1, int color2, float progress) {
        float[] f1 = new TintColor(color1, true).getComponents(null);
        if (color1 != color2) {
            float[] f2 = new TintColor(color2, true).getComponents(null);
            for (int i = 0; i < f1.length; ++i) {
                f2[i] = Mth.lerp((float)(progress / 100.0f), (float)f1[i], (float)f2[i]);
            }
            return Pair.of((Object)f1, (Object)f2);
        }
        return Pair.of((Object)f1, (Object)f1);
    }
}

