/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom.pressure_tube;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.model.custom.pressure_tube.PressureTubeGeometry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public enum PressureTubeModelLoader implements IGeometryLoader<PressureTubeGeometry>
{
    INSTANCE;


    public PressureTubeGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        String pfx = jsonObject.has("prefix") ? jsonObject.get("prefix").getAsString() + "_" : "";
        BlockModel core = PressureTubeModelLoader.loadModel(PneumaticRegistry.RL("block/" + pfx + "pressure_tube_disconnected"));
        BlockModel connected = PressureTubeModelLoader.loadModel(PneumaticRegistry.RL("block/" + pfx + "pressure_tube_connected"));
        BlockModel closed = PressureTubeModelLoader.loadModel(PneumaticRegistry.RL("block/" + pfx + "pressure_tube_closed"));
        return new PressureTubeGeometry(pfx, core, connected, closed);
    }

    private static BlockModel loadModel(ResourceLocation location) {
        BlockModel blockModel;
        block8: {
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            ResourceLocation file = ModelBakery.MODEL_LISTER.idToFile(location);
            InputStream stream = manager.getResourceOrThrow(file).open();
            try {
                blockModel = BlockModel.fromStream((Reader)new InputStreamReader(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JsonParseException("Failed to load part model '" + String.valueOf(file) + "'", (Throwable)e);
                }
            }
            stream.close();
        }
        return blockModel;
    }
}

