/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom.pressure_tube;

import com.mojang.math.Transformation;
import java.util.function.Function;
import me.desht.pneumaticcraft.client.model.custom.pressure_tube.PressureTubeModel;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Vector3f;

public record PressureTubeGeometry(String tubeType, BlockModel core, BlockModel connected, BlockModel closed) implements IUnbakedGeometry<PressureTubeGeometry>
{
    private static final Vector3f BLOCK_CENTER = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final BlockModelRotation[] ROTATIONS = new BlockModelRotation[]{BlockModelRotation.X180_Y0, BlockModelRotation.X0_Y0, BlockModelRotation.X90_Y0, BlockModelRotation.X90_Y180, BlockModelRotation.X90_Y270, BlockModelRotation.X90_Y90};

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        BakedModel[] rotatedCore = new BakedModel[6];
        BakedModel[] rotatedConnected = new BakedModel[6];
        BakedModel[] rotatedClosed = new BakedModel[6];
        for (Direction dir : DirectionUtil.VALUES) {
            int d = dir.get3DDataValue();
            ModelState rotatedState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)ROTATIONS[d].getRotation().applyOrigin(BLOCK_CENTER));
            rotatedCore[d] = this.core.bake(baker, this.core, spriteGetter, rotatedState, true);
            rotatedConnected[d] = this.connected.bake(baker, this.connected, spriteGetter, rotatedState, true);
            rotatedClosed[d] = this.closed.bake(baker, this.closed, spriteGetter, rotatedState, true);
        }
        return new PressureTubeModel(this.tubeType, this.core.bake(baker, this.core, spriteGetter, modelState, true), rotatedCore, rotatedConnected, rotatedClosed);
    }
}

