/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class WidgetComboBox
extends WidgetTextField
implements IDrawAfterRender {
    private final ArrayList<String> elements;
    private final Font fontRenderer;
    private boolean enabled;
    private boolean fixedOptions;
    private boolean shouldSort;
    private int selectedIndex;
    private final int baseHeight;
    private final Consumer<WidgetComboBox> pressable;
    private List<String> applicable;
    private boolean expanded;

    public WidgetComboBox(Font fontRenderer, int x, int y, int width, int height) {
        this(fontRenderer, x, y, width, height, b -> {});
    }

    public WidgetComboBox(Font fontRenderer, int x, int y, int width) {
        Objects.requireNonNull(fontRenderer);
        this(fontRenderer, x, y, width, 9 + 3, b -> {});
    }

    public WidgetComboBox(Font fontRenderer, int x, int y, int width, Consumer<WidgetComboBox> pressable) {
        Objects.requireNonNull(fontRenderer);
        this(fontRenderer, x, y, width, 9 + 3, pressable);
    }

    public WidgetComboBox(Font fontRenderer, int x, int y, int width, int height, Consumer<WidgetComboBox> pressable) {
        super(fontRenderer, x, y, width, height);
        this.elements = new ArrayList();
        this.enabled = true;
        this.shouldSort = true;
        this.selectedIndex = -1;
        this.applicable = null;
        this.expanded = false;
        this.fontRenderer = fontRenderer;
        this.baseHeight = height;
        this.pressable = pressable;
        this.setTextColorUneditable(0xE0E0E0);
    }

    public WidgetComboBox setElements(Collection<String> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setElements(String[] elements) {
        this.elements.clear();
        this.elements.ensureCapacity(elements.length);
        this.elements.addAll(Arrays.asList(elements));
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setShouldSort(boolean shouldSort) {
        this.shouldSort = shouldSort;
        return this;
    }

    private List<String> getApplicableElements() {
        this.applicable = this.elements.stream().filter(element -> this.fixedOptions || element.toLowerCase().contains(this.getValue().toLowerCase())).collect(Collectors.toList());
        return this.applicable;
    }

    public void insertText(String textToWrite) {
        super.insertText(textToWrite);
        this.applicable = null;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(this.fontRenderer, this.expanded ? "\u25b2" : "\u25bc", this.getX() + this.width - 7, this.getY() + 1, 0xC0C0C0, false);
    }

    @Override
    public void renderAfterEverythingElse(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.enabled && this.active && this.expanded) {
            int x = this.getX();
            int y = this.getY();
            List<String> applicableElements = this.getApplicableElements();
            int n = applicableElements.size();
            Objects.requireNonNull(this.fontRenderer);
            graphics.fill(x - 1, y + this.height + 1, x + this.width + 1, y + this.height + 3 + n * 9, -6250336);
            int n2 = applicableElements.size();
            Objects.requireNonNull(this.fontRenderer);
            graphics.fill(x, y + this.height + 1, x + this.width, y + this.height + 2 + n2 * 9, -16777216);
            Objects.requireNonNull(this.fontRenderer);
            int hovered = (mouseY - y - this.height) / 9;
            for (int i = 0; i < applicableElements.size(); ++i) {
                String element = applicableElements.get(i);
                String string = this.fontRenderer.plainSubstrByWidth(element, this.getWidth());
                Objects.requireNonNull(this.fontRenderer);
                graphics.drawString(this.fontRenderer, string, x + 4, y + this.height + 2 + i * 9, i == hovered ? 16769152 : 0xE0E0E0);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isVisible() && this.active && button == 0) {
            boolean flag;
            int n;
            int x = this.getX();
            int y = this.getY();
            if (this.expanded) {
                int n2 = this.getApplicableElements().size();
                Objects.requireNonNull(this.fontRenderer);
                n = n2 * 9;
            } else {
                n = 0;
            }
            int h = this.baseHeight + n;
            boolean bl = flag = mouseX >= (double)x && mouseX < (double)(x + this.width) && mouseY >= (double)y && mouseY < (double)(y + h);
            if (flag) {
                if (mouseY < (double)(y + this.height)) {
                    this.expanded = !this.expanded;
                } else {
                    this.expanded = false;
                    int n3 = (int)mouseY - y - this.height;
                    Objects.requireNonNull(this.fontRenderer);
                    int i = n3 / 9;
                    if (i < this.getApplicableElements().size()) {
                        this.setValue(this.getApplicableElements().get(i));
                        this.selectedIndex = i;
                        this.pressable.accept(this);
                    }
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        List<String> applicableElements;
        if (this.fixedOptions) {
            return false;
        }
        if (this.enabled && this.expanded && keyCode == 258 && !(applicableElements = this.getApplicableElements()).isEmpty()) {
            this.setValue(applicableElements.getFirst());
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char key, int keyCode) {
        return !this.fixedOptions && super.charTyped(key, keyCode);
    }

    public void setEditable(boolean enabled) {
        super.setEditable(enabled);
        this.enabled = enabled;
    }

    public WidgetComboBox setFixedOptions(boolean fixed) {
        this.fixedOptions = fixed;
        super.setEditable(!fixed);
        this.applicable = null;
        return this;
    }

    public int getSelectedElementIndex() {
        return this.selectedIndex;
    }

    public void selectElement(int index) {
        if (index >= 0 && index < this.elements.size()) {
            this.selectedIndex = index;
            this.setValue(this.elements.get(index));
        }
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue, Function<T, String> xlate) {
        List<String> labels = Arrays.stream((Enum[])initialValue.getDeclaringClass().getEnumConstants()).map(xlate).toList();
        this.setShouldSort(false);
        this.setElements(labels);
        this.setFixedOptions(true);
        this.selectElement(initialValue.ordinal());
        return this;
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue) {
        if (initialValue instanceof ITranslatableEnum) {
            return this.initFromEnum(initialValue, t -> {
                String string;
                if (t instanceof ITranslatableEnum) {
                    ITranslatableEnum e = (ITranslatableEnum)((Object)t);
                    string = PneumaticCraftUtils.xlate(e.getTranslationKey(), new Object[0]).getString();
                } else {
                    string = "???";
                }
                return string;
            });
        }
        throw new IllegalArgumentException(String.valueOf(initialValue) + " must implement ITranslatableEnum!");
    }
}

