/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.config;

import java.util.Objects;
import me.desht.pneumaticcraft.api.remote.IRemoteVariableWidget;
import me.desht.pneumaticcraft.client.gui.remote.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.AbstractRemoteConfigScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public abstract class AbstractRemoteVariableConfigScreen<A extends IRemoteVariableWidget>
extends AbstractRemoteConfigScreen<A> {
    private boolean playerGlobal;
    private WidgetButtonExtended varTypeButton;
    private WidgetComboBox variableField;

    public AbstractRemoteVariableConfigScreen(A widget, RemoteEditorScreen guiRemote) {
        super(widget, guiRemote);
    }

    @Override
    public void init() {
        super.init();
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variableName", new Object[0]), this.guiLeft + 10, this.guiTop + 70);
        this.playerGlobal = ((IRemoteVariableWidget)this.remoteWidget).varName().isEmpty() || ((IRemoteVariableWidget)this.remoteWidget).varName().startsWith("#");
        this.varTypeButton = new WidgetButtonExtended(this.guiLeft + 10, this.guiTop + 78, 12, 14, GlobalVariableHelper.getInstance().getVarPrefix(this.playerGlobal), b -> this.togglePlayerGlobal()).setTooltipKey("pneumaticcraft.gui.remote.varType.tooltip");
        this.addRenderableWidget((GuiEventListener)this.varTypeButton);
        Objects.requireNonNull(this.font);
        this.variableField = new WidgetComboBox(this.font, this.guiLeft + 23, this.guiTop + 79, 147, 9 + 3);
        this.variableField.setElements(this.extractVarnames(this.playerGlobal));
        this.variableField.setValue(GlobalVariableHelper.getInstance().stripVarPrefix(((IRemoteVariableWidget)this.remoteWidget).varName()));
        this.variableField.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.variable.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.variableField);
    }

    protected String makeVarName() {
        return GlobalVariableHelper.getInstance().getPrefixedVar(this.variableField.getValue(), this.playerGlobal);
    }

    private void togglePlayerGlobal() {
        this.playerGlobal = !this.playerGlobal;
        this.variableField.setElements(this.extractVarnames(this.playerGlobal));
        this.varTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getInstance().getVarPrefix(this.playerGlobal)));
    }
}

