/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;

public class ProgWidgetGuiManager {
    private static final Map<ProgWidgetType<? extends IProgWidget>, ProgWidgetGuiFactory<? extends IProgWidget>> widgetToGuiMap = new HashMap<ProgWidgetType<? extends IProgWidget>, ProgWidgetGuiFactory<? extends IProgWidget>>();

    public static <P extends IProgWidget> void registerProgWidgetGui(Supplier<ProgWidgetType<P>> typeSupplier, ProgWidgetGuiFactory<P> factory) {
        widgetToGuiMap.put(typeSupplier.get(), factory);
    }

    public static <P extends IProgWidget> boolean hasGui(P widget) {
        return widgetToGuiMap.containsKey(widget.getType());
    }

    public static <P extends IProgWidget> AbstractProgWidgetScreen<P> getGui(P widget, ProgrammerScreen programmer) {
        ProgWidgetGuiFactory<? extends IProgWidget> factory = widgetToGuiMap.get(widget.getType());
        return factory == null ? null : factory.createGui(widget, programmer);
    }

    @FunctionalInterface
    public static interface ProgWidgetGuiFactory<P extends IProgWidget> {
        public AbstractProgWidgetScreen<P> createGui(P var1, ProgrammerScreen var2);
    }
}

