/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.client.gui.GPSToolScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetAreaToolScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GPSAreaToolScreen
extends GPSToolScreen {
    private static final int CHANGE_AREA_BUTTON_WIDTH = 138;
    private static final int P1P2_BUTTON_WIDTH = 30;
    private final BlockPos[] p1p2Pos = new BlockPos[2];
    private final String[] vars = new String[2];
    private final boolean[] playerGlobals = new boolean[2];
    private int index;

    private GPSAreaToolScreen(ItemStack stack, InteractionHand hand, int index) {
        super(stack.getHoverName(), hand, GPSAreaToolItem.getGPSLocation((Player)Minecraft.getInstance().player, stack, index).orElse(ClientUtils.getClientPlayer().blockPosition()), GPSAreaToolItem.getVariable((Player)Minecraft.getInstance().player, stack, index));
        this.index = index;
        for (int i = 0; i <= 1; ++i) {
            this.p1p2Pos[i] = GPSAreaToolItem.getGPSLocation((Player)Minecraft.getInstance().player, stack, i).orElse(ClientUtils.getClientPlayer().blockPosition());
            this.vars[i] = GPSAreaToolItem.getVariable((Player)Minecraft.getInstance().player, stack, i);
            this.playerGlobals[i] = !this.vars[i].startsWith("%");
            this.vars[i] = GlobalVariableHelper.getInstance().stripVarPrefix(this.vars[i]);
        }
    }

    public static void showGUI(ItemStack stack, InteractionHand hand, int index) {
        Minecraft.getInstance().setScreen((Screen)new GPSAreaToolScreen(stack, hand, index));
    }

    @Override
    public void init() {
        super.init();
        int xMiddle = this.width / 2;
        int yMiddle = this.height / 2;
        int x = xMiddle - 69;
        int y = yMiddle + 100;
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(this.hand);
        ProgWidgetArea area = GPSAreaToolItem.getArea(ClientUtils.getClientPlayer(), stack);
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(x, y, 138, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.gps_area_tool.changeAreaType", new Object[0]), b -> this.minecraft.setScreen((Screen)new ProgWidgetAreaToolScreen(area, this.hand, () -> this.minecraft.setScreen((Screen)new GPSAreaToolScreen(stack, this.hand, this.index))))));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(xMiddle - 15, yMiddle - 45, 30, 20, this.getToggleLabel(), this::toggleP1P2));
    }

    @Override
    protected int getIndex() {
        return this.index;
    }

    @Override
    protected void syncToServer() {
        this.p1p2Pos[this.index] = new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
        this.vars[this.index] = this.variableField.getValue();
        for (int i = 0; i <= 1; ++i) {
            if (!this.changed(i)) continue;
            String varName = GlobalVariableHelper.getInstance().getPrefixedVar(this.vars[i], this.playerGlobals[i]);
            NetworkHandler.sendToServer(new PacketChangeGPSToolCoordinate(this.p1p2Pos[i], this.hand, varName, i, i == this.index));
        }
    }

    private boolean changed(int index) {
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(this.hand);
        BlockPos p = GPSAreaToolItem.getGPSLocation(ClientUtils.getClientPlayer(), stack, index).orElse(PneumaticCraftUtils.invalidPos());
        String var = GPSAreaToolItem.getVariable(ClientUtils.getClientPlayer(), stack, index);
        String var2 = GlobalVariableHelper.getInstance().getPrefixedVar(this.vars[index], this.playerGlobals[index]);
        return !p.equals((Object)this.p1p2Pos[index]) || !var.equals(var2);
    }

    @Override
    protected void toggleVarType() {
        this.playerGlobals[this.index] = !this.playerGlobals[this.index];
        this.varTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getInstance().getVarPrefix(this.playerGlobals[this.index])));
    }

    private void toggleP1P2(Button b) {
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(this.hand);
        if (stack.getItem() instanceof GPSAreaToolItem) {
            this.p1p2Pos[this.index] = new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
            this.vars[this.index] = this.variableField.getValue();
            this.index = 1 - this.index;
            b.setMessage(this.getToggleLabel());
            this.textFields[0].setValue(this.p1p2Pos[this.index].getX());
            this.textFields[1].setValue(this.p1p2Pos[this.index].getY());
            this.textFields[2].setValue(this.p1p2Pos[this.index].getZ());
            this.variableField.setValue(this.vars[this.index]);
            this.varTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getInstance().getVarPrefix(this.playerGlobals[this.index])));
            if (this.teleportButton != null) {
                BlockPos pos = this.getBlockPos();
                this.teleportButton.setTooltipText((Component)Component.literal((String)String.format("/tp %d %d %d", pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    private Component getToggleLabel() {
        ChatFormatting color = this.index == 0 ? ChatFormatting.RED : ChatFormatting.GREEN;
        return Component.literal((String)("P" + (this.index + 1))).withStyle(color);
    }
}

