/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.pneumatic_armor;

import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public abstract class AttributeModifyingArmorUpgradeHandler<T extends IArmorExtensionData>
extends BaseArmorUpgradeHandler<T> {
    protected abstract Holder<Attribute> getModifiedAttribute();

    protected abstract double getModifiedAttributeValue(ICommonArmorHandler var1);

    protected ResourceLocation getModifierId() {
        return this.getID();
    }

    protected boolean isAttributeModifierApplicable(ICommonArmorHandler handler) {
        return true;
    }

    protected AttributeModifier.Operation getModifierOperation() {
        return AttributeModifier.Operation.ADD_VALUE;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        AttributeInstance attributeInstance = player.getAttribute(this.getModifiedAttribute());
        if (attributeInstance != null) {
            double newValue;
            AttributeModifier currentModifier = attributeInstance.getModifier(this.getModifierId());
            double d = newValue = enabled && commonArmorHandler.hasMinPressure(this.getEquipmentSlot()) && this.isAttributeModifierApplicable(commonArmorHandler) ? this.getModifiedAttributeValue(commonArmorHandler) : 0.0;
            if (currentModifier != null) {
                if (Math.abs(currentModifier.amount() - newValue) < (double)1.0E-5f) {
                    return;
                }
                attributeInstance.removeModifier(currentModifier.id());
            }
            if (newValue > 0.0) {
                attributeInstance.addTransientModifier(new AttributeModifier(this.getModifierId(), newValue, this.getModifierOperation()));
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        if (!newState) {
            this.removeModifier(commonArmorHandler);
        }
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        this.removeModifier(commonArmorHandler);
    }

    private void removeModifier(ICommonArmorHandler commonArmorHandler) {
        AttributeModifier currentModifier;
        AttributeInstance attributeInstance = commonArmorHandler.getPlayer().getAttribute(this.getModifiedAttribute());
        if (attributeInstance != null && (currentModifier = attributeInstance.getModifier(this.getModifierId())) != null) {
            attributeInstance.removeModifier(currentModifier.id());
        }
    }
}

