/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.cheat;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class VirtualInventoryCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        boolean enabled = false;
        enabled |= FTBEConfig.ANVIL.isEnabled();
        enabled |= FTBEConfig.CRAFTING_TABLE.isEnabled();
        enabled |= FTBEConfig.SMITHING_TABLE.isEnabled();
        return enabled |= FTBEConfig.STONECUTTER.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        LiteralArgumentBuilder openCommand = (LiteralArgumentBuilder)Commands.literal((String)"open").requires(CommandUtils.isGamemaster());
        if (FTBEConfig.ANVIL.isEnabled()) {
            openCommand.then(VirtualInventoryCommand.createMenu("anvil", "block.minecraft.anvil", VirtualAnvilMenu::new));
        }
        if (FTBEConfig.CRAFTING_TABLE.isEnabled()) {
            openCommand.then(VirtualInventoryCommand.createMenu("crafting", "block.minecraft.crafting_table", VirtualCraftingMenu::new));
        }
        if (FTBEConfig.SMITHING_TABLE.isEnabled()) {
            openCommand.then(VirtualInventoryCommand.createMenu("smithing", "block.minecraft.smithing_table", VirtualSmithingMenu::new));
        }
        if (FTBEConfig.STONECUTTER.isEnabled()) {
            openCommand.then(VirtualInventoryCommand.createMenu("stonecutter", "block.minecraft.stonecutter", VirtualStoneCutterMenu::new));
        }
        return Collections.singletonList(openCommand);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> createMenu(String name, String translate, VirtualMenuFactory factory) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> factory.create(id, inv, (ServerPlayer)p), (Component)Component.translatable((String)translate)));
            return 1;
        });
    }

    @FunctionalInterface
    public static interface VirtualMenuFactory {
        public AbstractContainerMenu create(int var1, Inventory var2, ServerPlayer var3);
    }

    private static class VirtualCraftingMenu
    extends CraftingMenu {
        public VirtualCraftingMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        }

        public boolean stillValid(Player player) {
            return true;
        }
    }

    private static class VirtualStoneCutterMenu
    extends StonecutterMenu {
        public VirtualStoneCutterMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        }

        public boolean stillValid(Player player) {
            return true;
        }
    }

    private static class VirtualSmithingMenu
    extends SmithingMenu {
        public VirtualSmithingMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        }

        protected boolean isValidBlock(BlockState blockState) {
            return true;
        }
    }

    private static class VirtualAnvilMenu
    extends AnvilMenu {
        public VirtualAnvilMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        }

        protected boolean isValidBlock(BlockState blockState) {
            return true;
        }
    }
}

