/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.JSONUtils;

public class WeightedRandom<T>
implements IRandom<T> {
    public static final JsonReader<Item> ITEM = entries -> {
        Builder builder = new Builder();
        entries.forEach(element -> {
            JsonObject entry = element.getAsJsonObject();
            int weight = JSONUtils.getWeight(entry);
            builder.add(RandomEquipment.getItem(ResourceLocation.parse((String)entry.get("item").getAsString())), weight);
        });
        return builder.build();
    };
    private final int totalWeight;
    private final ImmutableList<Tuple<T, Integer>> entries;
    private final ImmutableList<Tuple<T, Integer>> originalEntries;

    public WeightedRandom(List<Tuple<T, Integer>> entries) {
        this.originalEntries = ImmutableList.copyOf(entries);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int weight = 0;
        for (Tuple<T, Integer> entry : entries) {
            if ((Integer)entry.getB() <= 0) continue;
            builder.add((Object)new Tuple(entry.getA(), (Object)(weight += ((Integer)entry.getB()).intValue())));
        }
        this.entries = builder.build();
        this.totalWeight = weight;
    }

    @Override
    public T roll(RandomSource rand) {
        int r = rand.nextInt(this.totalWeight);
        for (Tuple entry : this.entries) {
            if (r >= (Integer)entry.getB()) continue;
            return (T)entry.getA();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public ImmutableList<Tuple<T, Integer>> getEntries() {
        return this.originalEntries;
    }

    public static class Builder<T> {
        public final List<Tuple<T, Integer>> entries = Lists.newArrayList();

        public Builder<T> add(T t, int weight) {
            this.entries.add(new Tuple(t, (Object)weight));
            return this;
        }

        public void addAll(Collection<Tuple<T, Integer>> entries) {
            this.entries.addAll(entries);
        }

        public WeightedRandom<T> build() {
            return new WeightedRandom<T>(this.entries);
        }
    }

    @FunctionalInterface
    public static interface JsonReader<T> {
        public WeightedRandom<T> fromJson(JsonArray var1);
    }
}

