/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;

public interface ModelLoader {
    public static final ModelLoader VERSION_1 = (nbt, file, key) -> {
        ImmutableList.Builder modelBlocks = new ImmutableList.Builder();
        ListTag blocks = nbt.getList("blocks", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            DungeonModelBlock block = DungeonModelBlock.fromNBT(blocks.getCompound(i));
            if (block != null) {
                modelBlocks.add((Object)block);
                continue;
            }
            DungeonCrawl.LOGGER.error("Loading a block from {} (version 1) returned null", (Object)file);
        }
        return new DungeonModel(key, (ImmutableList<DungeonModelBlock>)modelBlocks.build(), nbt.getInt("width"), nbt.getInt("height"), nbt.getInt("length"));
    };
    public static final ModelLoader LEGACY = (nbt, file, key) -> {
        int width = nbt.getInt("width");
        int height = nbt.getInt("height");
        int length = nbt.getInt("length");
        ListTag blocks = nbt.getList("model", 9);
        ImmutableList.Builder modelBlocks = new ImmutableList.Builder();
        for (int x = 0; x < width; ++x) {
            ListTag blocks2 = blocks.getList(x);
            for (int y = 0; y < height; ++y) {
                ListTag blocks3 = blocks2.getList(y);
                for (int z = 0; z < length; ++z) {
                    DungeonModelBlock block = DungeonModelBlock.fromNBT(blocks3.getCompound(z), new Vec3i(x, y, z));
                    if (block != null) {
                        modelBlocks.add((Object)block);
                        continue;
                    }
                    DungeonCrawl.LOGGER.error("Loading a block from {} (legacy) returned null", (Object)file);
                }
            }
        }
        return new DungeonModel(key, (ImmutableList<DungeonModelBlock>)modelBlocks.build(), width, height, length);
    };

    public DungeonModel load(CompoundTag var1, ResourceLocation var2, ResourceLocation var3);
}

