/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.FilterableRecipe;
import net.mehvahdjukaar.sawmill.SawmillMenu;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SawmillScreen
extends AbstractContainerScreen<SawmillMenu> {
    private static final ResourceLocation BACKGROUND = SawmillMod.res("textures/gui/container/sawmill.png");
    private static final ResourceLocation BACKGROUND_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search.png");
    private static final ResourceLocation BACKGROUND_WIDE = SawmillMod.res("textures/gui/container/sawmill_wide.png");
    private static final ResourceLocation BACKGROUND_WIDE_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search_wide.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
    private static final ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_selected");
    private static final ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_highlighted");
    private static final ResourceLocation RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private EditBox searchBox;
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private int filteredIndex = -1;

    public SawmillScreen(SawmillMenu sawmillMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)sawmillMenu, inventory, component);
        sawmillMenu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    protected void init() {
        super.init();
        int boxX = this.leftPos + (((SawmillMenu)this.menu).isWide ? 41 : 53);
        int boxY = this.topPos + 15;
        this.searchBox = new EditBox(this.font, boxX, boxY, 69, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setFocused(false);
        this.searchBox.setEditable(false);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setResponder(s -> this.refreshSearchResults());
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.updateSearchBarVisibility();
    }

    private void updateSearchBarVisibility() {
        boolean hasSearch;
        this.searchBox.visible = hasSearch = CommonConfigs.hasSearchBar(((SawmillMenu)this.menu).getRecipes().size());
        this.searchBox.active = hasSearch;
    }

    protected void containerTick() {
        super.containerTick();
    }

    private void refreshSearchResults() {
        int oldSize = this.filteredRecipes.size();
        this.filteredRecipes.clear();
        String filter = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        boolean isFiltered = this.searchBox.visible && !filter.equals("");
        for (FilterableRecipe r : ((SawmillMenu)this.menu).getRecipes()) {
            if (isFiltered && !r.matchFilter(filter)) continue;
            this.filteredRecipes.add(r);
        }
        if (oldSize != this.filteredRecipes.size()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateSelectedIndex();
        if (this.filteredIndex == -1 && ((SawmillMenu)this.menu).getSelectedRecipeIndex() != -1 && ((SawmillMenu)this.menu).clickMenuButton((Player)this.minecraft.player, -1)) {
            this.minecraft.gameMode.handleInventoryButtonClick(((SawmillMenu)this.menu).containerId, -1);
        }
        this.updateSearchBarVisibility();
    }

    private void updateSelectedIndex() {
        this.filteredIndex = -1;
        int selectedInd = ((SawmillMenu)this.menu).getSelectedRecipeIndex();
        List<FilterableRecipe> recipes = ((SawmillMenu)this.menu).getRecipes();
        if (selectedInd > -1 && selectedInd < recipes.size()) {
            this.filteredIndex = this.filteredRecipes.indexOf(recipes.get(selectedInd));
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String string = this.searchBox.getValue();
        this.init(minecraft, width, height);
        this.searchBox.setValue(string);
        this.containerChanged();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        String string = this.searchBox.getValue();
        if (this.searchBox.visible && this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.isFocused() && this.searchBox.isVisible() && keyCode != 256 ? true : super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        ResourceLocation bgLocation = this.getBgLocation();
        guiGraphics.blit(bgLocation, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int barH = this.scrollBarHeight();
        int scrollY = this.minScrollY();
        float barSpan = this.maxScrollY() - scrollY - barH;
        int barPos = (int)(barSpan * this.scrollOffs);
        ResourceLocation resourceLocation = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(resourceLocation, this.minScrollX(), scrollY + barPos, 12, barH);
        if (!this.displayRecipes) {
            return;
        }
        this.forEachButton((index, buttonX, buttonY) -> {
            ResourceLocation buttonTexture = index == this.filteredIndex ? RECIPE_SELECTED_SPRITE : (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            guiGraphics.blitSprite(buttonTexture, buttonX, buttonY, 16, 18);
        });
        this.forEachButton((index, buttonX, buttonY) -> {
            ItemStack item = ((WoodcuttingRecipe)this.filteredRecipes.get(index).recipe().value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess());
            guiGraphics.renderFakeItem(item, buttonX, buttonY + 1);
            guiGraphics.renderItemDecorations(this.font, item, buttonX, buttonY + 1);
        });
    }

    @NotNull
    private ResourceLocation getBgLocation() {
        if (((SawmillMenu)this.menu).isWide) {
            return this.searchBox.visible ? BACKGROUND_WIDE_SEARCH : BACKGROUND_WIDE;
        }
        return this.searchBox.visible ? BACKGROUND_SEARCH : BACKGROUND;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            this.forEachButton((index, buttonX, buttonY) -> {
                if (mouseX >= buttonX && mouseX < buttonX + 16 && mouseY >= buttonY && mouseY < buttonY + 18) {
                    guiGraphics.renderTooltip(this.font, ((WoodcuttingRecipe)this.filteredRecipes.get(index).recipe().value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), mouseX, mouseY);
                }
            });
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int input;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (this.filteredIndex >= 0 && this.filteredIndex < this.filteredRecipes.size() && (input = ((WoodcuttingRecipe)this.filteredRecipes.get(this.filteredIndex).recipe().value()).getInputCount()) != 1) {
            String multiplier = input + "x";
            int labelX = this.titleLabelX + (((SawmillMenu)this.menu).isWide ? -4 : 0);
            guiGraphics.drawString(this.font, multiplier, labelX, this.titleLabelY + 37, 0x404040, false);
        }
    }

    private int getButtonCount() {
        return this.getRowCount() * this.getButtonsPerRow();
    }

    private int getButtonsPerRow() {
        return ((SawmillMenu)this.menu).isWide ? 5 : 4;
    }

    private int getRowCount() {
        return this.searchBox.visible ? 2 : 3;
    }

    private int minScrollX() {
        return this.leftPos + (((SawmillMenu)this.menu).isWide ? 123 : 119);
    }

    private int maxScrollX() {
        return this.minScrollX() + 12;
    }

    private int minScrollY() {
        return this.topPos + (this.searchBox.visible ? 29 : 15);
    }

    private int maxScrollY() {
        return this.topPos + (this.searchBox.visible ? 65 : 70);
    }

    private int scrollBarHeight() {
        return this.searchBox.visible ? 11 : 15;
    }

    private void forEachButton(ButtonConsumer buttonConsumer) {
        int buttonBoxX = this.leftPos + (((SawmillMenu)this.menu).isWide ? 40 : 52);
        int buttonBoxY = this.topPos + (this.searchBox.visible ? 27 : 13);
        int lastVisibleElementIndex = this.startIndex + this.getButtonCount();
        int buttonsPerRow = this.getButtonsPerRow();
        for (int index = this.startIndex; index < lastVisibleElementIndex && index < this.filteredRecipes.size(); ++index) {
            int visualIndex = index - this.startIndex;
            int buttonX = buttonBoxX + visualIndex % buttonsPerRow * 16;
            int buttonY = buttonBoxY + visualIndex / buttonsPerRow * 18 + 2;
            buttonConsumer.accept(index, buttonX, buttonY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
            this.forEachButton((index, buttonX, buttonY) -> {
                if (((Boolean)success.get()).booleanValue()) {
                    return;
                }
                int actualIndex = ((SawmillMenu)this.menu).getRecipes().indexOf(this.filteredRecipes.get(index));
                if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 18)) {
                    if (((SawmillMenu)this.menu).clickMenuButton((Player)this.minecraft.player, actualIndex)) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SawmillMod.SAWMILL_SELECT.get(), (float)1.0f));
                        this.minecraft.gameMode.handleInventoryButtonClick(((SawmillMenu)this.menu).containerId, actualIndex);
                        this.updateSelectedIndex();
                    }
                    success.set(true);
                }
            });
            if (success.get().booleanValue()) {
                return true;
            }
            if (mouseX >= (double)this.minScrollX() && mouseX < (double)this.maxScrollX() && mouseY >= (double)this.minScrollY() && mouseY < (double)this.maxScrollY()) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int min = this.minScrollY();
            int max = this.maxScrollY();
            this.scrollOffs = ((float)mouseY - (float)min - 7.5f) / ((float)(max - min) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * this.getButtonsPerRow();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * this.getButtonsPerRow();
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.filteredRecipes.size() > this.getButtonCount();
    }

    protected int getOffscreenRows() {
        int buttonsPerRow = this.getButtonsPerRow();
        return (this.filteredRecipes.size() + buttonsPerRow - 1) / buttonsPerRow - this.getRowCount();
    }

    private void containerChanged() {
        this.displayRecipes = ((SawmillMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.searchBox.setValue("");
        } else {
            this.setFocused((GuiEventListener)this.searchBox);
        }
        this.searchBox.setEditable(this.displayRecipes);
        this.searchBox.setFocused(this.displayRecipes);
        this.refreshSearchResults();
    }

    private static interface ButtonConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

