/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.ShapedRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.ShapelessRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.SmeltingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public final class StandardRecipes {
    public static void apply(MaterialBuilder.RecipeContext ctx) {
        StandardRecipes.add3By3Crafting(ctx, MIParts.TINY_DUST, MIParts.DUST, true);
        StandardRecipes.add3By3Crafting(ctx, MIParts.NUGGET, MIParts.INGOT, true);
        StandardRecipes.add3By3Crafting(ctx, ctx.get(MaterialProperty.MAIN_PART), MIParts.BLOCK, false);
        StandardRecipes.add3By3Crafting(ctx, MIParts.RAW_METAL, MIParts.RAW_METAL_BLOCK, true);
        new ShapedRecipeBuilder(ctx, MIParts.BLADE, 4, "blade", "P", "P", "I").addTaggedPart('P', MIParts.CURVED_PLATE).addTaggedPart('I', MIParts.ROD).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapelessRecipeBuilder(ctx, MIParts.ORE, 1, "deepslate_to_ore").addPart(MIParts.ORE_DEEPSLATE);
        new ShapedRecipeBuilder(ctx, MIParts.COIL, 1, "coil", "xxx", "x x", "xxx").addTaggedPart('x', MIParts.CABLE).exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.LARGE_PLATE, 1, "large_plate", "xx", "xx").addTaggedPart('x', MIParts.PLATE).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapedRecipeBuilder(ctx, MIParts.ROTOR, 1, "rotor", "bBb", "BRB", "bBb").addTaggedPart('b', MIParts.BOLT).addTaggedPart('B', MIParts.BLADE).addTaggedPart('R', MIParts.RING);
        new ShapedRecipeBuilder(ctx, MIParts.GEAR, 1, "gear", "PbP", "bRb", "PbP").addTaggedPart('b', MIParts.BOLT).addTaggedPart('P', MIParts.PLATE).addTaggedPart('R', MIParts.RING);
        new ShapedRecipeBuilder(ctx, MIParts.HAMMER, 1, "hammer", "ppp", "psp", " s ").addTaggedPart('p', MIParts.LARGE_PLATE).addInput('s', (ItemLike)Items.STICK);
        new ShapedRecipeBuilder(ctx, MIParts.RING, 2, "ring", "bRb", "R R", "bRb").addTaggedPart('b', MIParts.BOLT).addTaggedPart('R', MIParts.ROD);
        new ShapedRecipeBuilder(ctx, MIParts.CABLE, 3, "cable", "rrr", "www", "rrr").addInput('r', MIItem.RUBBER_SHEET).addTaggedPart('w', MIParts.WIRE).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapedRecipeBuilder(ctx, MIParts.TANK, 1, "tank", "###", "#G#", "###").addTaggedPart('#', MIParts.PLATE).addInput('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.BARREL, 1, "barrel", "###", "#b#", "###").addTaggedPart('#', MIParts.PLATE).addInput('b', (TagKey<Item>)Tags.Items.BARRELS_WOODEN).exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.DRILL_HEAD, 1, "drill_head", "bcp", "GRc", "bGb").addTaggedPart('G', MIParts.GEAR).addPart('b', MIParts.BOLT).addPart('c', MIParts.CURVED_PLATE).addTaggedPart('R', MIParts.ROD).addTaggedPart('p', MIParts.PLATE);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.DOUBLE_INGOT, 18);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.PLATE, 9);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.CURVED_PLATE, 9);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.NUGGET, 1);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.LARGE_PLATE, 36);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.GEAR, 18);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.RING, 4);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.BOLT, 2);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.ROD, 4);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.ROTOR, 27);
        if (!ctx.get(MaterialProperty.MAIN_PART).equals(MIParts.DUST)) {
            StandardRecipes.addMaceratorRecycling(ctx, ctx.get(MaterialProperty.MAIN_PART), 9);
        }
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.BLADE, 5);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.DRILL_HEAD, 67);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.WIRE, 4);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "ore_to_crushed").addTaggedPartInput(MIParts.ORE, 1).addPartOutput(MIParts.CRUSHED_DUST, 3);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "ore_to_raw").addTaggedPartInput(MIParts.ORE, 1).addPartOutput(MIParts.RAW_METAL, 3);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "crushed_dust", 2, (int)(100.0 * ctx.get(MaterialProperty.HARDNESS).timeFactor)).addTaggedPartInput(MIParts.CRUSHED_DUST, 1).addPartOutput(MIParts.DUST, 1).addPartOutput(MIParts.DUST, 1, 0.5f);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "raw_metal", 2, (int)(100.0 * ctx.get(MaterialProperty.HARDNESS).timeFactor)).addTaggedPartInput(MIParts.RAW_METAL, 1).addPartOutput(MIParts.DUST, 1).addPartOutput(MIParts.DUST, 1, 0.5f);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "main").addTaggedPartInput(ctx.get(MaterialProperty.MAIN_PART), 1).addPartOutput(MIParts.PLATE, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "plate").addTaggedPartInput(MIParts.PLATE, 1).addPartOutput(MIParts.CURVED_PLATE, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "double_ingot").addTaggedPartInput(MIParts.DOUBLE_INGOT, 1).addPartOutput(MIParts.PLATE, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "ring").addTaggedPartInput(MIParts.ROD, 1).addPartOutput(MIParts.RING, 1);
        StandardRecipes.addCuttingMachine(ctx, "main", ctx.get(MaterialProperty.MAIN_PART), MIParts.ROD, 2);
        StandardRecipes.addCuttingMachine(ctx, "double_ingot", MIParts.DOUBLE_INGOT, MIParts.ROD, 4);
        StandardRecipes.addCuttingMachine(ctx, "rod", MIParts.ROD, MIParts.BOLT, 2);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "block").addTaggedPartInput(ctx.get(MaterialProperty.MAIN_PART), 9).addItemInput(MIItem.PACKER_BLOCK_TEMPLATE, 1, 0.0f)).addPartOutput(MIParts.BLOCK, 1);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "double_ingot").addTaggedPartInput(MIParts.INGOT, 2).addItemInput(MIItem.PACKER_DOUBLE_INGOT_TEMPLATE, 1, 0.0f)).addPartOutput(MIParts.DOUBLE_INGOT, 1);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "fuel_rod_double").addPartInput(MIParts.FUEL_ROD, 2).addItemInput("#c:plates/nuclear_alloy", 1)).addPartOutput(MIParts.FUEL_ROD_DOUBLE, 1);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "fuel_rod_quad").addItemInput("#c:plates/nuclear_alloy", 2)).addPartInput(MIParts.FUEL_ROD_DOUBLE, 2).addPartOutput(MIParts.FUEL_ROD_QUAD, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.UNPACKER, "coil").addTaggedPartInput(MIParts.COIL, 1).addPartOutput(MIParts.CABLE, 8);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.WIREMILL, "wire").addTaggedPartInput(MIParts.PLATE, 1).addPartOutput(MIParts.WIRE, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.WIREMILL, "fine_wire").addTaggedPartInput(MIParts.WIRE, 1).addPartOutput(MIParts.FINE_WIRE, 4);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "rotor").addTaggedPartInput(MIParts.BLADE, 4).addTaggedPartInput(MIParts.RING, 1).addFluidInput(MIFluids.SOLDERING_ALLOY, 100)).addPartOutput(MIParts.ROTOR, 1);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "gear").addTaggedPartInput(MIParts.PLATE, 4).addTaggedPartInput(MIParts.RING, 1).addFluidInput(MIFluids.SOLDERING_ALLOY, 100)).addPartOutput(MIParts.GEAR, 2);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "drill_head").addTaggedPartInput(MIParts.PLATE, 1).addTaggedPartInput(MIParts.CURVED_PLATE, 2).addTaggedPartInput(MIParts.ROD, 1).addTaggedPartInput(MIParts.GEAR, 2).addFluidInput(MIFluids.SOLDERING_ALLOY, 75)).addPartOutput(MIParts.DRILL_HEAD, 1);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "cable_synthetic_rubber").addTaggedPartInput(MIParts.WIRE, 3).addFluidInput(MIFluids.SYNTHETIC_RUBBER, 30)).addPartOutput(MIParts.CABLE, 3);
        ((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "cable_styrene_rubber").addTaggedPartInput(MIParts.WIRE, 3).addFluidInput(MIFluids.STYRENE_BUTADIENE_RUBBER, 6)).addPartOutput(MIParts.CABLE, 3);
        ((MIRecipeBuilder)((MIRecipeBuilder)((MIRecipeBuilder)((MIRecipeBuilder)((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "fuel_rod", 16, 200).addItemInput("modern_industrialization:blastproof_alloy_curved_plate", 2)).addItemInput(MIItem.LARGE_MOTOR, 1)).addItemInput(MIItem.ROBOT_ARM, 2)).addTaggedPartInput(MIParts.ROD, 18).addFluidInput(MIFluids.SOLDERING_ALLOY, 500)).addFluidInput(MIFluids.HELIUM, 100)).addPartOutput(MIParts.FUEL_ROD, 1);
        ((MIRecipeBuilder)((MIRecipeBuilder)new MIRecipeBuilder(ctx, MIMachineRecipeTypes.HEAT_EXCHANGER, "hot_ingot", 8, 10).addPartInput(MIParts.HOT_INGOT, 1).addFluidInput(MIFluids.CRYOFLUID, 20)).addPartOutput(MIParts.INGOT, 1).addFluidOutput(MIFluids.ARGON, 13)).addFluidOutput(MIFluids.HELIUM, 5);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.POLARIZER, "rod_magnetic", 8, 200).addTaggedPartInput(MIParts.ROD, 1).addPartOutput(MIParts.ROD_MAGNETIC, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.POLARIZER, "wire_magnetic", 8, 200).addTaggedPartInput(MIParts.WIRE, 1).addPartOutput(MIParts.WIRE_MAGNETIC, 1);
        new SmeltingRecipeBuilder(ctx, MIParts.ROD_MAGNETIC, MIParts.ROD, 0.0f, false);
        new SmeltingRecipeBuilder(ctx, MIParts.WIRE_MAGNETIC, MIParts.WIRE, 0.0f, false);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.VACUUM_FREEZER, "hot_ingot", 32, 250).addTaggedPartInput(MIParts.HOT_INGOT, 1).addPartOutput(MIParts.INGOT, 1);
    }

    private static void addMaceratorRecycling(MaterialBuilder.RecipeContext ctx, PartKeyProvider partInput, int tinyDustOutput) {
        MIRecipeBuilder builder = new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, partInput);
        builder.addTaggedPartInput(partInput, 1);
        if (tinyDustOutput % 9 == 0) {
            builder.addPartOutput(MIParts.DUST, tinyDustOutput / 9);
        } else {
            while (tinyDustOutput > 64) {
                builder.addPartOutput(MIParts.TINY_DUST, 64);
                tinyDustOutput -= 64;
            }
            builder.addPartOutput(MIParts.TINY_DUST, tinyDustOutput);
        }
    }

    private static void add3By3Crafting(MaterialBuilder.RecipeContext ctx, PartKeyProvider smallPart, PartKeyProvider bigPart, boolean packer) {
        if (ctx.hasInternalPart(smallPart) || ctx.hasInternalPart(bigPart)) {
            new ShapedRecipeBuilder(ctx, bigPart, 1, String.valueOf(bigPart.key()) + "_from_" + String.valueOf(smallPart.key()), "xxx", "xyx", "xxx").addPart('y', smallPart).addTaggedPart('x', smallPart);
            new ShapelessRecipeBuilder(ctx, smallPart, 9, String.valueOf(smallPart.key()) + "_from_" + String.valueOf(bigPart.key())).addPart(bigPart);
        }
        if (packer) {
            new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, bigPart).addTaggedPartInput(smallPart, 9).addPartOutput(bigPart, 1);
        }
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.UNPACKER, smallPart).addTaggedPartInput(bigPart, 1).addPartOutput(smallPart, 9);
    }

    private static void addCuttingMachine(MaterialBuilder.RecipeContext ctx, String name, PartKeyProvider inputPart, PartKeyProvider outputPart, int amount) {
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.CUTTING_MACHINE, name).addTaggedPartInput(inputPart, 1).addPartOutput(outputPart, amount).addFluidInput("modern_industrialization:lubricant", 1);
    }
}

