/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.property;

import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialHardness;
import aztech.modern_industrialization.materials.set.MaterialSet;
import aztech.modern_industrialization.nuclear.IsotopeFuelParams;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class MaterialProperty<T> {
    private static final Map<String, MaterialProperty<?>> PROPERTY_IDS = new HashMap();
    public static final Collection<MaterialProperty<?>> PROPERTIES = Collections.unmodifiableCollection(PROPERTY_IDS.values());
    public final T defaultValue;
    public static final MaterialProperty<Integer> MEAN_RGB = new MaterialProperty<Integer>("mean_rgb", 0);
    public static final MaterialProperty<MaterialHardness> HARDNESS = new MaterialProperty<MaterialHardness>("hardness", MaterialHardness.AVERAGE);
    public static final MaterialProperty<PartKeyProvider> MAIN_PART = new MaterialProperty<PartTemplate>("main_part", MIParts.INGOT);
    public static final MaterialProperty<MaterialSet> SET = new MaterialProperty<MaterialSet>("material_set", MaterialSet.DULL);
    public static final MaterialProperty<@Nullable IsotopeFuelParams> ISOTOPE = new MaterialProperty<Object>("isotope", null);

    public MaterialProperty(String id, T defaultValue) {
        this.defaultValue = defaultValue;
        if (PROPERTY_IDS.put(id, this) != null) {
            throw new IllegalArgumentException("Duplicate material property id: " + id);
        }
    }
}

