/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.nuclear.NuclearOrder;

public class ControlRodPart
implements PartKeyProvider {
    @Override
    public PartKey key() {
        return MIParts.FUEL_ROD.key;
    }

    public PartTemplate of(int maxTemperature, double heatConduction, double thermalAbsorbProba, double fastAbsorbProba, double thermalScatteringProba, double fastScatteringProba, NuclearConstant.ScatteringType scatteringType, double size) {
        return new PartTemplate("Control Rod", this.key()).withRegister((partContext, part, itemPath1, itemId, itemTag, itemEnglishName) -> NuclearAbsorbable.of(partContext.getMaterialEnglishName() + " Control Rod", itemPath1, maxTemperature, heatConduction * 0.01, NeutronBehaviour.of(scatteringType, new IsotopeParams(thermalAbsorbProba, fastAbsorbProba, thermalScatteringProba, fastScatteringProba), size), 10240000, SortOrder.NUCLEAR.create(NuclearOrder.CONTROL_ROD))).withCustomPath("%s_control_rod");
    }

    public PartTemplate of(int maxTemperature, double heatConduction, NuclearConstant.ScatteringType scatteringType, IsotopeParams params, double size) {
        return new PartTemplate("Control Rod", this.key()).withRegister((partContext, part, itemPath1, itemId, itemTag, itemEnglishName) -> NuclearAbsorbable.of(partContext.getMaterialEnglishName() + " Control Rod", itemPath1, maxTemperature, heatConduction * 0.01, NeutronBehaviour.of(scatteringType, params, size), 10240000, SortOrder.NUCLEAR.create(NuclearOrder.CONTROL_ROD))).withCustomPath("%s_control_rod");
    }
}

