/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface SimpleMember {
    public boolean matchesState(BlockState var1);

    public BlockState getPreviewState();

    public static SimpleMember forBlock(final Supplier<? extends Block> block) {
        Objects.requireNonNull(block);
        return new SimpleMember(){

            @Override
            public boolean matchesState(BlockState state) {
                return state.is((Block)block.get());
            }

            @Override
            public BlockState getPreviewState() {
                return ((Block)block.get()).defaultBlockState();
            }
        };
    }

    public static SimpleMember forBlockId(ResourceLocation id) {
        return SimpleMember.forBlock(() -> (Block)BuiltInRegistries.BLOCK.get(id));
    }

    public static SimpleMember forBlockState(final BlockState state) {
        Objects.requireNonNull(state);
        return new SimpleMember(){

            @Override
            public boolean matchesState(BlockState state2) {
                return state == state2;
            }

            @Override
            public BlockState getPreviewState() {
                return state;
            }
        };
    }

    public static SimpleMember verticalChain() {
        return new SimpleMember(){

            @Override
            public boolean matchesState(BlockState state) {
                return state.is(Blocks.CHAIN) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y;
            }

            @Override
            public BlockState getPreviewState() {
                return (BlockState)Blocks.CHAIN.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
            }
        };
    }
}

