/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.datagen.model.MachineModelProperties;
import aztech.modern_industrialization.datagen.model.MachineModelsToGenerate;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.FluidHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.ItemHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.LargeTankHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.NuclearHatch;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.init.MachineDefinition;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiblockHatches {
    public static final HatchPair<ItemHatch> BRONZE_ITEM = MultiblockHatches.registerItemHatches("Bronze", "bronze", MachineCasings.BRONZE, 1, 1, 80, 40);
    public static final HatchPair<ItemHatch> STEEL_ITEM = MultiblockHatches.registerItemHatches("Steel", "steel", MachineCasings.STEEL, 2, 1, 80, 30);
    public static final HatchPair<ItemHatch> ADVANCED_ITEM = MultiblockHatches.registerItemHatches("Advanced", "advanced", CableTier.MV.casing, 2, 2, 71, 30);
    public static final HatchPair<ItemHatch> TURBO_ITEM = MultiblockHatches.registerItemHatches("Turbo", "turbo", CableTier.HV.casing, 3, 3, 62, 21);
    public static final HatchPair<ItemHatch> HIGHLY_ADVANCED_ITEM = MultiblockHatches.registerItemHatches("Highly Advanced", "highly_advanced", CableTier.EV.casing, 3, 5, 44, 18);
    public static final HatchPair<FluidHatch> BRONZE_FLUID = MultiblockHatches.registerFluidHatches("Bronze", "bronze", MachineCasings.BRONZE, 4);
    public static final HatchPair<FluidHatch> STEEL_FLUID = MultiblockHatches.registerFluidHatches("Steel", "steel", MachineCasings.STEEL, 16);
    public static final HatchPair<FluidHatch> ADVANCED_FLUID = MultiblockHatches.registerFluidHatches("Advanced", "advanced", CableTier.MV.casing, 64);
    public static final HatchPair<FluidHatch> TURBO_FLUID = MultiblockHatches.registerFluidHatches("Turbo", "turbo", CableTier.HV.casing, 256);
    public static final HatchPair<FluidHatch> HIGHLY_ADVANCED_FLUID = MultiblockHatches.registerFluidHatches("Highly Advanced", "highly_advanced", CableTier.EV.casing, 1024);
    public static final HatchPair<EnergyHatch> LV_ENERGY = MultiblockHatches.registerEnergyHatches(CableTier.LV);
    public static final HatchPair<EnergyHatch> MV_ENERGY = MultiblockHatches.registerEnergyHatches(CableTier.MV);
    public static final HatchPair<EnergyHatch> HV_ENERGY = MultiblockHatches.registerEnergyHatches(CableTier.HV);
    public static final HatchPair<EnergyHatch> EV_ENERGY = MultiblockHatches.registerEnergyHatches(CableTier.EV);
    public static final HatchPair<EnergyHatch> SUPERCONDUCTOR_ENERGY = MultiblockHatches.registerEnergyHatches(CableTier.SUPERCONDUCTOR);
    public static final MachineDefinition<NuclearHatch> NUCLEAR_ITEM = MachineRegistrationHelper.registerMachine("Nuclear Item Hatch", "nuclear_item_hatch", bet -> new NuclearHatch((BEP)bet, false), NuclearHatch::registerItemApi);
    public static final MachineDefinition<NuclearHatch> NUCLEAR_FLUID = MachineRegistrationHelper.registerMachine("Nuclear Fluid Hatch", "nuclear_fluid_hatch", bet -> new NuclearHatch((BEP)bet, true), NuclearHatch::registerFluidApi);
    public static final MachineDefinition<LargeTankHatch> LARGE_TANK = MachineRegistrationHelper.registerMachine("Large Tank Hatch", "large_tank_hatch", LargeTankHatch::new, LargeTankHatch::registerFluidApi);
    private static final int FLUID_HATCH_SLOT_X = 80;
    private static final int FLUID_HATCH_SLOT_Y = 40;

    public static void init() {
        MachineModelsToGenerate.register("nuclear_item_hatch", new MachineModelProperties.Builder(MachineCasings.NUCLEAR).addOverlay("top", MI.id("block/overlays/output_item")).addOverlay("item_auto", MI.id("block/overlays/item_auto")).build());
        MachineModelsToGenerate.register("nuclear_fluid_hatch", new MachineModelProperties.Builder(MachineCasings.NUCLEAR).addOverlay("top", MI.id("block/overlays/output_fluid")).addOverlay("fluid_auto", MI.id("block/overlays/fluid_auto")).build());
        MachineRegistrationHelper.addMachineModel("large_tank_hatch", "hatch_fluid", MachineCasings.STEEL, false, false, true, false);
        KubeJSProxy.instance.fireRegisterHatchesEvent();
    }

    public static HatchPair<ItemHatch> registerItemHatches(String englishPrefix, String prefix, MachineCasing casing, int rows, int columns, int xStart, int yStart) {
        ArrayList<MachineDefinition<ItemHatch>> definitions = new ArrayList<MachineDefinition<ItemHatch>>(2);
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = prefix + "_item_" + (input ? "input" : "output") + "_hatch";
            String englishName = englishPrefix + " Item" + (input ? " Input" : " Output") + " Hatch";
            MachineDefinition<ItemHatch> def = MachineRegistrationHelper.registerMachine(englishName, machine, bet -> {
                ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
                for (int i = 0; i < rows * columns; ++i) {
                    if (input) {
                        itemStacks.add(ConfigurableItemStack.standardInputSlot());
                        continue;
                    }
                    itemStacks.add(ConfigurableItemStack.standardOutputSlot());
                }
                MIInventory inventory = new MIInventory(itemStacks, Collections.emptyList(), new SlotPositions.Builder().addSlots(xStart, yStart, columns, rows).build(), SlotPositions.empty());
                return new ItemHatch((BEP)bet, new MachineGuiParameters.Builder(machine, true).build(), input, !prefix.equals("bronze"), inventory);
            }, MachineBlockEntity::registerItemApi);
            definitions.add(def);
            MachineModelProperties.Builder model = new MachineModelProperties.Builder(casing);
            model.addOverlay("side", MI.id("block/machines/hatch_item/overlay_side"));
            model.addOverlay("output", MI.id("block/overlays/output_item"));
            model.addOverlay("item_auto", MI.id("block/overlays/item_auto"));
            MachineModelsToGenerate.register(machine, model.build());
        }
        return new HatchPair<ItemHatch>((MachineDefinition)definitions.get(0), (MachineDefinition)definitions.get(1));
    }

    public static HatchPair<FluidHatch> registerFluidHatches(String englishPrefix, String prefix, MachineCasing casing, int bucketCapacity) {
        ArrayList<MachineDefinition<FluidHatch>> definitions = new ArrayList<MachineDefinition<FluidHatch>>(2);
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = prefix + "_fluid_" + (input ? "input" : "output") + "_hatch";
            String englishName = englishPrefix + " Fluid" + (input ? " Input" : " Output") + " Hatch";
            MachineDefinition<FluidHatch> def = MachineRegistrationHelper.registerMachine(englishName, machine, bet -> {
                List<ConfigurableFluidStack> fluidStacks = Collections.singletonList(input ? ConfigurableFluidStack.standardInputSlot((long)bucketCapacity * 1000L) : ConfigurableFluidStack.standardOutputSlot((long)bucketCapacity * 1000L));
                MIInventory inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), new SlotPositions.Builder().addSlot(80, 40).build());
                return new FluidHatch((BEP)bet, new MachineGuiParameters.Builder(machine, true).build(), input, !prefix.equals("bronze"), inventory);
            }, MachineBlockEntity::registerFluidApi);
            definitions.add(def);
            MachineModelProperties.Builder model = new MachineModelProperties.Builder(casing);
            model.addOverlay("side", MI.id("block/machines/hatch_fluid/overlay_side"));
            model.addOverlay("output", MI.id("block/overlays/output_fluid"));
            model.addOverlay("fluid_auto", MI.id("block/overlays/fluid_auto"));
            MachineModelsToGenerate.register(machine, model.build());
        }
        return new HatchPair<FluidHatch>((MachineDefinition)definitions.get(0), (MachineDefinition)definitions.get(1));
    }

    public static HatchPair<EnergyHatch> registerEnergyHatches(CableTier tier) {
        ArrayList<MachineDefinition<EnergyHatch>> definitions = new ArrayList<MachineDefinition<EnergyHatch>>(2);
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = tier.name + "_energy_" + (input ? "input" : "output") + "_hatch";
            String englishName = tier.shortEnglishName + " Energy" + (input ? " Input" : " Output") + " Hatch";
            MachineDefinition<EnergyHatch> def = MachineRegistrationHelper.registerMachine(englishName, machine, bet -> new EnergyHatch((BEP)bet, new MachineGuiParameters.Builder(machine, false).build(), input, tier), EnergyHatch::registerEnergyApi);
            definitions.add(def);
            MachineModelProperties.Builder model = new MachineModelProperties.Builder(tier.casing);
            model.addOverlay("side", MI.id("block/machines/hatch_energy/overlay_side"));
            if (!input) {
                model.addOverlay("output", MI.id("block/overlays/output_energy"));
            }
            MachineModelsToGenerate.register(machine, model.build());
        }
        return new HatchPair<EnergyHatch>((MachineDefinition)definitions.get(0), (MachineDefinition)definitions.get(1));
    }

    public record HatchPair<T extends HatchBlockEntity>(MachineDefinition<T> input, MachineDefinition<T> output) {
    }
}

