/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.nuclear.NuclearTileData;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Unit;

public record NuclearReactorGui(Supplier<Data> dataSupplier) implements GuiComponentServer<Unit, Data>
{
    public static final GuiComponentServer.Type<Unit, Data> TYPE = new GuiComponentServer.Type(MI.id("nuclear_reactor_gui"), StreamCodec.unit((Object)Unit.INSTANCE), Data.STREAM_CODEC);
    private static final double neutronsMax = 8192.0;

    @Override
    public Unit getParams() {
        return Unit.INSTANCE;
    }

    @Override
    public Data extractData() {
        return this.dataSupplier.get();
    }

    @Override
    public GuiComponentServer.Type<Unit, Data> getType() {
        return TYPE;
    }

    public static double neutronColorScheme(double neutronNumber) {
        neutronNumber = Math.min(neutronNumber, 8192.0);
        return Math.log(1.0 + 10.0 * neutronNumber) / Math.log(81921.0);
    }

    public record Data(boolean valid, int gridSizeX, int gridSizeY, List<TileData> tilesData, double euProduction, double euFuelConsumption) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Data::valid, (StreamCodec)ByteBufCodecs.VAR_INT, Data::gridSizeX, (StreamCodec)ByteBufCodecs.VAR_INT, Data::gridSizeY, (StreamCodec)TileData.STREAM_CODEC.apply(ByteBufCodecs.list()), Data::tilesData, (StreamCodec)ByteBufCodecs.DOUBLE, Data::euProduction, (StreamCodec)ByteBufCodecs.DOUBLE, Data::euFuelConsumption, Data::new);

        public int toIndex(int x, int y) {
            return Data.toIndex(x, y, this.gridSizeY);
        }

        public static int toIndex(int x, int y, int sizeY) {
            return x * sizeY + y;
        }
    }

    public record TileData(Optional<NuclearTileData> data) {
        public static final StreamCodec<RegistryFriendlyByteBuf, TileData> STREAM_CODEC = StreamCodec.ofMember(NuclearTileData::write, NuclearTileData::read).map(TileData::new, TileData::data);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            Optional<NuclearTileData> odata;
            if (!(obj instanceof TileData)) return false;
            TileData tileData = (TileData)obj;
            try {
                Optional<NuclearTileData> optional;
                odata = optional = tileData.data();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (!NuclearTileData.areEquals(this.data, odata)) return false;
            return true;
        }
    }
}

