/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class OverclockComponent
implements MachineComponent {
    private final List<Catalyst> catalysts;
    private final NavigableMap<Double, MutableTickCount> tickMap = new TreeMap<Double, MutableTickCount>();

    public OverclockComponent(List<Catalyst> catalysts) {
        this.catalysts = catalysts;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        for (Map.Entry entry : this.tickMap.entrySet()) {
            String multiplierKey = String.format("overclock%.2f", (double)((Double)entry.getKey()));
            tag.putInt(multiplierKey, ((MutableTickCount)entry.getValue()).value);
        }
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        for (Catalyst catalyst : this.catalysts) {
            String multiplierKey = String.format("overclock%.2f", catalyst.multiplier);
            if (!tag.contains(multiplierKey) || this.tickMap.containsKey(catalyst.multiplier)) continue;
            this.tickMap.put(catalyst.multiplier, new MutableTickCount(tag.getInt(multiplierKey)));
        }
    }

    public int getTicks() {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null) {
            return lastEntry.getValue().value;
        }
        return 0;
    }

    public ItemInteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        ResourceLocation resourceInHand = BuiltInRegistries.ITEM.getKey((Object)stackInHand.getItem());
        for (Catalyst catalyst : this.catalysts) {
            if (!resourceInHand.equals((Object)catalyst.resourceLocation) || stackInHand.getCount() < 1) continue;
            if (!player.isCreative()) {
                stackInHand.shrink(1);
            }
            if (this.tickMap.containsKey(catalyst.multiplier)) {
                MutableTickCount overclockTicks = (MutableTickCount)this.tickMap.get(catalyst.multiplier);
                overclockTicks.value += catalyst.ticks;
            } else {
                this.tickMap.put(catalyst.multiplier, new MutableTickCount(catalyst.ticks));
            }
            be.setChanged();
            if (!be.getLevel().isClientSide()) {
                be.sync();
            }
            return ItemInteractionResult.sidedSuccess((boolean)be.getLevel().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void tick(MachineBlockEntity be) {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null) {
            MutableTickCount overclockTicks = lastEntry.getValue();
            --overclockTicks.value;
            if (overclockTicks.value <= 0) {
                this.tickMap.remove(lastEntry.getKey());
            } else if (be.getLevel().isClientSide()) {
                for (int iter = 0; iter < 3; ++iter) {
                    RandomSource random = be.getLevel().getRandom();
                    double d = (double)be.getBlockPos().getX() + 0.5;
                    double e = be.getBlockPos().getY();
                    double f = (double)be.getBlockPos().getZ() + 0.5;
                    double i = random.nextDouble() * 0.6 - 0.3;
                    double k = random.nextDouble() * 0.6 - 0.3;
                    be.getLevel().addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i, e + 1.05, f + k, 0.15 * (random.nextDouble() - 0.5), 0.15, 0.15 * (random.nextDouble() - 0.5));
                }
            }
        }
    }

    public List<Component> getTooltips() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (Catalyst catalyst : this.catalysts) {
            Item catalystItem = (Item)BuiltInRegistries.ITEM.get(catalyst.resourceLocation);
            tooltips.add((Component)MITooltips.line(MIText.OverclockMachine).arg(catalystItem, MITooltips.ITEM_PARSER).arg(catalyst.multiplier).arg(catalyst.ticks).build());
        }
        return tooltips;
    }

    public long getRecipeEu(int eu) {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null && lastEntry.getValue().value > 0) {
            return Math.round(lastEntry.getKey() * (double)eu);
        }
        return eu;
    }

    public static List<Catalyst> getDefaultCatalysts() {
        return List.of(new Catalyst(2.0, ResourceLocation.parse((String)"minecraft:gunpowder"), 2400));
    }

    private static class MutableTickCount {
        public int value;

        public MutableTickCount(int value) {
            this.value = value;
        }
    }

    public record Catalyst(double multiplier, ResourceLocation resourceLocation, int ticks) {
    }
}

