/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class MachineInventoryComponent
implements CrafterComponent.Inventory,
MachineComponent.ServerOnly {
    public final int itemInputCount;
    public final int itemOutputCount;
    public final int fluidInputCount;
    public final int fluidOutputCount;
    public final MIInventory inventory;
    private int invHash = 0;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        protected void onChange() {
            ++MachineInventoryComponent.this.invHash;
        }

        @Override
        protected boolean isValid(Object token) {
            return true;
        }
    };

    public MachineInventoryComponent(List<ConfigurableItemStack> itemInputs, List<ConfigurableItemStack> itemOutputs, List<ConfigurableFluidStack> fluidInputs, List<ConfigurableFluidStack> fluidOutputs, SlotPositions itemPositions, SlotPositions fluidPositions) {
        this.itemInputCount = itemInputs.size();
        this.itemOutputCount = itemOutputs.size();
        this.fluidInputCount = fluidInputs.size();
        this.fluidOutputCount = fluidOutputs.size();
        ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
        itemStacks.addAll(itemInputs);
        itemStacks.addAll(itemOutputs);
        ArrayList<ConfigurableFluidStack> fluidStacks = new ArrayList<ConfigurableFluidStack>();
        fluidStacks.addAll(fluidInputs);
        fluidStacks.addAll(fluidOutputs);
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.inventory.addListener(this.listener, null);
    }

    @Override
    public List<ConfigurableItemStack> getItemInputs() {
        return this.inventory.getItemStacks().subList(0, this.itemInputCount);
    }

    @Override
    public List<ConfigurableItemStack> getItemOutputs() {
        return this.inventory.getItemStacks().subList(this.itemInputCount, this.itemInputCount + this.itemOutputCount);
    }

    @Override
    public List<ConfigurableFluidStack> getFluidInputs() {
        return this.inventory.getFluidStacks().subList(0, this.fluidInputCount);
    }

    @Override
    public List<ConfigurableFluidStack> getFluidOutputs() {
        return this.inventory.getFluidStacks().subList(this.fluidInputCount, this.fluidInputCount + this.fluidOutputCount);
    }

    @Override
    public int hash() {
        return this.invHash;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.inventory.writeNbt(tag, registries);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.inventory.readNbt(tag, registries, isUpgradingMachine);
        this.inventory.addListener(this.listener, null);
    }
}

