/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.tag;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.ItemDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class TagsToGenerate {
    private static final Map<TagKey<Item>, List<ItemLike>> tagToItemMap = new HashMap<TagKey<Item>, List<ItemLike>>();
    static final Set<TagKey<Item>> optionalTags = new HashSet<TagKey<Item>>();
    public static final Map<String, String> tagTranslations = new HashMap<String, String>();
    static final Map<String, Set<String>> tagToBeAddedToAnotherTag = new HashMap<String, Set<String>>();

    static Map<TagKey<Item>, List<Item>> getTags() {
        HashMap<TagKey<Item>, List<Item>> ret = HashMap.newHashMap(tagToItemMap.size());
        for (Map.Entry<TagKey<Item>, List<ItemLike>> entry : tagToItemMap.entrySet()) {
            ArrayList<Item> items = new ArrayList<Item>(entry.getValue().size());
            for (ItemLike item : entry.getValue()) {
                items.add(item.asItem());
            }
            items.sort((item1, item2) -> {
                ResourceLocation key1 = BuiltInRegistries.ITEM.getKey((Object)item1.asItem());
                ResourceLocation key2 = BuiltInRegistries.ITEM.getKey((Object)item2.asItem());
                ItemDefinition def1 = (ItemDefinition)MIItem.ITEM_DEFINITIONS.get(key1);
                ItemDefinition def2 = (ItemDefinition)MIItem.ITEM_DEFINITIONS.get(key2);
                if (def1 != null && def2 != null) {
                    return def1.sortOrder.compareTo(def2.sortOrder);
                }
                return key1.compareTo(key2);
            });
            ret.put(entry.getKey(), items);
        }
        return ret;
    }

    private static void addTranslation(String tag, String tagEnglishName) {
        ResourceLocation tagId = ResourceLocation.parse((String)tag);
        tagTranslations.put("tag.%s.%s".formatted(tagId.getNamespace(), tagId.getPath()).replace('/', '.'), tagEnglishName);
    }

    public static void generateTag(String tag, ItemLike item, String tagEnglishName) {
        if (tag.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tag);
        }
        TagsToGenerate.generateTagNoTranslation((TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)tag)), item);
        TagsToGenerate.addTranslation(tag, tagEnglishName);
    }

    public static void generateTagNoTranslation(TagKey<Item> tag, ItemLike item) {
        tagToItemMap.computeIfAbsent(tag, t -> new ArrayList()).add(item);
    }

    public static void addTagToTag(String tagTobeAdded, String tagTarget, String targetEnglishName) {
        if (tagTobeAdded.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTobeAdded);
        }
        if (tagTarget.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTarget);
        }
        tagToBeAddedToAnotherTag.computeIfAbsent(tagTarget, t -> new TreeSet()).add(tagTobeAdded);
        TagsToGenerate.addTranslation(tagTarget, targetEnglishName);
    }

    public static void generateTag(TagKey<Item> tag, ItemLike item, String tagEnglishName) {
        TagsToGenerate.generateTag(tag.location().toString(), item, tagEnglishName);
    }

    public static void markTagOptional(TagKey<Item> tag) {
        optionalTags.add(tag);
    }
}

