/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.tag;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.pipes.MIPipes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jspecify.annotations.Nullable;

public class MIBlockTagProvider
extends BlockTagsProvider {
    public MIBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "modern_industrialization", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (BlockDefinition<?> blockDefinition : MIBlock.BLOCK_DEFINITIONS.values()) {
            for (TagKey<Block> tag : blockDefinition.tags) {
                this.tag(tag).add(blockDefinition.asBlock());
            }
        }
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)MIPipes.BLOCK_PIPE.get());
        this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED).add((Object)MIPipes.BLOCK_PIPE.get());
        for (Map.Entry entry : TagsToGenerate.getTags().entrySet()) {
            boolean optional = TagsToGenerate.optionalTags.contains(entry.getKey());
            for (Item item : (List)entry.getValue()) {
                ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
                Optional block = BuiltInRegistries.BLOCK.getOptional(itemKey);
                if (block.isEmpty()) continue;
                TagKey key = BlockTags.create((ResourceLocation)((TagKey)entry.getKey()).location());
                if (optional) {
                    this.tag(key).addOptional(itemKey);
                    continue;
                }
                this.tag(key).add((Object)((Block)block.get()));
            }
        }
        for (Map.Entry entry : TagsToGenerate.tagToBeAddedToAnotherTag.entrySet()) {
            ResourceLocation tagId = ResourceLocation.parse((String)((String)entry.getKey()));
            for (String tag : (Set)entry.getValue()) {
                if (!this.builders.containsKey(ResourceLocation.parse((String)tag))) continue;
                this.tag(MIBlockTagProvider.key(tagId)).addTag(MIBlockTagProvider.key(tag));
            }
        }
    }

    private static TagKey<Block> key(ResourceLocation id) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)id);
    }

    private static TagKey<Block> key(String id) {
        return MIBlockTagProvider.key(ResourceLocation.parse((String)id));
    }
}

