/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.advancement;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIAdvancementTriggers;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.datagen.translation.TranslationProvider;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jspecify.annotations.Nullable;

public record MIAdvancementsProvider(TranslationProvider translations) implements AdvancementProvider.AdvancementGenerator
{
    private static Criterion<?> createSimpleCriterion(Supplier<PlayerTrigger> trigger) {
        return trigger.get().createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()));
    }

    private Component translateTitle(String path, String englishName) {
        String titleKey = "advancements.modern_industrialization." + path;
        this.translations.addTranslation(titleKey, englishName);
        return Component.translatable((String)titleKey);
    }

    private Component translateDescription(String path, String englishDescription) {
        String descKey = "advancements.modern_industrialization." + path + ".description";
        this.translations.addTranslation(descKey, englishDescription);
        return Component.translatable((String)descKey);
    }

    private Builder newBuilder(String path) {
        return new Builder(path).sendsTelemetryEvent();
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        AdvancementHolder guidebook = this.newBuilder("guidebook").display(MIItem.GUIDE_BOOK, (Component)MIText.ModernIndustrialization.text(), this.translateDescription("guidebook", "Welcome to Modern Industrialization! Make sure to check out the guidebook."), MI.id("textures/block/fire_clay_bricks.png"), AdvancementType.TASK, false, false, false).addCriterion("logged_in", (Criterion)MIAdvancementsProvider.createSimpleCriterion(MIAdvancementTriggers.PLAYER_LOGGED_IN)).save(consumer, existingFileHelper);
        AdvancementHolder forgeHammer = this.createBasic(consumer, "forge_hammer", guidebook, AdvancementType.GOAL, "Is This A Forge Mod?", "Craft a Forge Hammer and start exploring the mod.", existingFileHelper);
        AdvancementHolder steamMiningDrill = this.createBasic(consumer, "steam_mining_drill", forgeHammer, AdvancementType.GOAL, "Getting That 3x3 Going", "Craft a Steam Mining Drill", existingFileHelper);
        AdvancementHolder fireClayBricks = this.createBasic(consumer, "fire_clay_bricks", forgeHammer, "Almost Steam?", "Craft Fire Clay Bricks", existingFileHelper);
        AdvancementHolder bronzeFurnace = this.createBasic(consumer, "bronze_furnace", fireClayBricks, "Ten Times More Fuel Efficient", "Craft a Bronze Furnace", existingFileHelper);
        AdvancementHolder bronzeCompressor = this.createBasic(consumer, "bronze_compressor", forgeHammer, "An Automatic Forge Mod", "Craft a Bronze Compressor", existingFileHelper);
        AdvancementHolder bronzeMixer = this.createBasic(consumer, "bronze_mixer", forgeHammer, "Mixing Without Mixins", "Craft a Bronze Mixer", existingFileHelper);
        AdvancementHolder bronzeMacerator = this.createBasic(consumer, "bronze_macerator", forgeHammer, "Ore Hemiquadrupling", "Craft a Bronze Macerator", existingFileHelper);
        AdvancementHolder cokeOven = this.createBasic(consumer, "coke_oven", forgeHammer, AdvancementType.GOAL, "Coke-A Cola", "Craft a Coke Oven to start Steel Production", existingFileHelper);
        AdvancementHolder steamBlastFurnace = this.createBasic(consumer, "steam_blast_furnace", fireClayBricks, "Almost Steel!", "Craft a Steam Blast Furnace", existingFileHelper);
        AdvancementHolder steelMachineCasing = this.createBasic(consumer, "steel_machine_casing", steamBlastFurnace, AdvancementType.GOAL, "Cooked Uncooked Steel!", "Use a Steam Blast Furnace to produce Steel and craft a Steel Machine Casing", existingFileHelper);
        AdvancementHolder usedSteelUpgrade = this.newBuilder("used_steel_upgrade").display(MIItem.STEEL_UPGRADE, "Upgrade Like a Boss", "Right-click a Steel Upgrade on a bronze machine.", null, AdvancementType.TASK, true, true, false).parent(steelMachineCasing).addCriterion("used_steel_upgrade", (Criterion)MIAdvancementsProvider.createSimpleCriterion(MIAdvancementTriggers.USED_STEEL_UPGRADE)).save(consumer, existingFileHelper);
        AdvancementHolder steelWiremill = this.createBasic(consumer, "steel_wiremill", steelMachineCasing, "Neither a Wire nor a Mill", "Craft a Steel Wiremill", existingFileHelper);
        AdvancementHolder steamQuarry = this.createBasic(consumer, "steam_quarry", steelMachineCasing, AdvancementType.GOAL, "From Minecraft to Craft", "Craft a Steam Quarry and say goodbye to mining", existingFileHelper);
        AdvancementHolder steelPacket = this.createBasic(consumer, "steel_packer", steelMachineCasing, "To Pack Or Not To Pack", "Craft a Steel Packer", existingFileHelper);
        AdvancementHolder inductor = this.createBasic(consumer, "inductor", steelWiremill, "The L in RLC", "Craft an Inductor", existingFileHelper);
        AdvancementHolder resistor = this.createBasic(consumer, "resistor", steelWiremill, "The R in RLC", "Craft a Resistor", existingFileHelper);
        AdvancementHolder capacitor = this.createBasic(consumer, "capacitor", steelWiremill, "The C in RLC", "Craft a Capacitor", existingFileHelper);
        AdvancementHolder analogCircuit = this.createBasic(consumer, "analog_circuit", resistor, AdvancementType.GOAL, "RLC Circuits", "Craft an Analog Circuit and start the Electric Age", existingFileHelper);
        AdvancementHolder lvSteamTurbine = this.createBasic(consumer, "lv_steam_turbine", analogCircuit, "Better Than Solar Panels", "Craft a Steam Turbine", existingFileHelper);
        AdvancementHolder polarizer = this.createBasic(consumer, "polarizer", lvSteamTurbine, "One Recipe (+2) To Rule Them All", "Craft a Polarizer", existingFileHelper);
        AdvancementHolder largeSteamBoiler = this.createBasic(consumer, "large_steam_boiler", analogCircuit, "Kiss Your Fuel Goodbye!", "Craft a Large Steam Boiler", existingFileHelper);
        AdvancementHolder assembler = this.createBasic(consumer, "assembler", analogCircuit, AdvancementType.GOAL, "Avengers, Assemble!", "Craft an Assembler", existingFileHelper);
        AdvancementHolder mvLvTransformer = this.createBasic(consumer, "mv_lv_transformer", analogCircuit, "Optimus Prime!", "Craft an MV to LV Transformer", existingFileHelper);
        AdvancementHolder electricBlastFurnace = this.createBasic(consumer, "electric_blast_furnace", lvSteamTurbine, AdvancementType.GOAL, "Electric Best Friend", "Craft an Electric Blast Furnace to start producing Aluminum", existingFileHelper);
        AdvancementHolder electronicCircuit = this.createBasic(consumer, "electronic_circuit", electricBlastFurnace, "The Power of Silicon", "Craft a Electronic Circuit", existingFileHelper);
        AdvancementHolder centrifuge = this.createBasic(consumer, "centrifuge", electronicCircuit, "Actually It's The Centripetal Force", "Craft a Centrifuge", existingFileHelper);
        AdvancementHolder electrolyzer = this.createBasic(consumer, "electrolyzer", electronicCircuit, "It's Got What Plants Crave", "Craft an Electrolyzer", existingFileHelper);
        AdvancementHolder chemicalReactor = this.createBasic(consumer, "chemical_reactor", electronicCircuit, "Walter White Approves", "Craft a Chemical Reactor", existingFileHelper);
        AdvancementHolder distillery = this.createBasic(consumer, "distillery", electronicCircuit, "Al Capone Approves", "Craft a Distillery", existingFileHelper);
        AdvancementHolder electricQuarry = this.createBasic(consumer, "electric_quarry", electronicCircuit, AdvancementType.CHALLENGE, "Resource Goes BRRRRRR!!!", "Craft an Electric Quarry", existingFileHelper);
        AdvancementHolder oilDrillingRig = this.createBasic(consumer, "oil_drilling_rig", electronicCircuit, AdvancementType.GOAL, "Bringing Freedom To Your Country", "Craft an Oil Drilling Rig", existingFileHelper);
        AdvancementHolder vacuumFreezer = this.createBasic(consumer, "vacuum_freezer", electronicCircuit, AdvancementType.GOAL, "Enslaved Winter", "Craft a Vacuum Freezer", existingFileHelper);
        AdvancementHolder mvSteamTurbine = this.createBasic(consumer, "mv_steam_turbine", electronicCircuit, AdvancementType.GOAL, "Better Than Wind Mills", "Craft an Advanced Steam Turbine", existingFileHelper);
        AdvancementHolder dieselGenerator = this.createBasic(consumer, "mv_diesel_generator", distillery, "Fast and Furious", "Craft an MV Diesel Generator", existingFileHelper);
        AdvancementHolder dieselJetpack = this.createBasic(consumer, "diesel_jetpack", distillery, AdvancementType.CHALLENGE, "Ely... We Meant Jetpack!", "Craft a Diesel Jetpack", existingFileHelper);
        AdvancementHolder dieselChainsaw = this.createBasic(consumer, "diesel_chainsaw", distillery, AdvancementType.CHALLENGE, "The Texas Chain Saw Massacre", "Craft a Diesel Chainsaw", existingFileHelper);
        AdvancementHolder dieselMiningDrill = this.createBasic(consumer, "diesel_mining_drill", distillery, AdvancementType.CHALLENGE, "Through The Walls Of Ba Sing Se", "Craft a Diesel Mining Drill", existingFileHelper);
        AdvancementHolder digitalCircuit = this.createBasic(consumer, "digital_circuit", distillery, "No need for Sodium anymore", "Craft a Digital Circuit", existingFileHelper);
        AdvancementHolder turboDieselGenerator = this.createBasic(consumer, "hv_diesel_generator", dieselGenerator, "Fast and Furious 2: Revenge", "Craft an HV Diesel Generator", existingFileHelper);
        AdvancementHolder largeDieselGenerator = this.createBasic(consumer, "large_diesel_generator", turboDieselGenerator, "Fast and Furious 42: Armageddon", "Craft a Large Diesel Generator", existingFileHelper);
        AdvancementHolder hvSteamTurbine = this.createBasic(consumer, "hv_steam_turbine", mvSteamTurbine, "Better than Water Wheel", "Craft an HV Steam Turbine", existingFileHelper);
        AdvancementHolder largeSteamTurbine = this.createBasic(consumer, "large_steam_turbine", hvSteamTurbine, "Enslaved Hurricane", "Craft a Large Steam Turbine", existingFileHelper);
        AdvancementHolder distillationTower = this.createBasic(consumer, "distillation_tower", digitalCircuit, AdvancementType.GOAL, "TOTAL\u2122 Distillation", "Craft a Distillation Tower to unlock to full potential of oil processing", existingFileHelper);
        AdvancementHolder heatExchanger = this.createBasic(consumer, "heat_exchanger", digitalCircuit, "Lava Power but Balanced", "Craft a Heat Exchanger to avoid losing high pressure (and cheese easy energy from lava production)", existingFileHelper);
        AdvancementHolder stainlessSteel = this.createBasic(consumer, "stainless_steel_ingot", vacuumFreezer, AdvancementType.GOAL, "Invar with Slot Locking", "Craft a Stainless Steel Ingot", existingFileHelper);
        AdvancementHolder kanthalCoil = this.createBasic(consumer, "kanthal_coil", stainlessSteel, "Electric Better Furnace", "Craft a Kanthal Coil to unlock new EBF recipes", existingFileHelper);
        AdvancementHolder processingUnit = this.createBasic(consumer, "processing_unit", kanthalCoil, "Bitcoin Miner", "Craft a Processing Unit", existingFileHelper);
        AdvancementHolder titaniumIngot = this.createBasic(consumer, "titanium_ingot", kanthalCoil, "Steel but Pink", "Craft a Titanium Ingot", existingFileHelper);
        AdvancementHolder blastProofAlloyPlate = this.createBasic(consumer, "blastproof_alloy_plate", titaniumIngot, "Creeper Nightmare", "Craft a Blastproof Alloy Plate in the compressor", existingFileHelper);
        AdvancementHolder implosionCompressor = this.createBasic(consumer, "implosion_compressor", blastProofAlloyPlate, AdvancementType.GOAL, "Automated Creeper", "Craft an Implosion Compressor", existingFileHelper);
        AdvancementHolder pressurizer = this.createBasic(consumer, "pressurizer", titaniumIngot, "Under Pressure", "Craft a Pressurizer to unlock for efficient Steam Process", existingFileHelper);
        AdvancementHolder rawIridium = this.createBasic(consumer, "raw_iridium", titaniumIngot, "Diamond 2.0: Electric Boogaloo", "Obtain a Raw Piece of Iridium", existingFileHelper);
        AdvancementHolder superconductorCable = this.createBasic(consumer, "superconductor_cable", rawIridium, AdvancementType.GOAL, "Unlimited Power (Transfer)", "Craft a Superconductor Cable to transfer unlimited amount of energy", existingFileHelper);
        AdvancementHolder gravichestplate = this.createBasic(consumer, "gravichestplate", superconductorCable, AdvancementType.CHALLENGE, "Gravichestplate\u2122", "Craft a Gravichestplate to unlock creative flight", existingFileHelper);
        AdvancementHolder nuclearReactor = this.createBasic(consumer, "nuclear_reactor", implosionCompressor, AdvancementType.CHALLENGE, "3.6 Roentgen", "Craft a Nuclear Reactor and discover its overengineered mechanisms", existingFileHelper);
        AdvancementHolder nuke = this.createBasic(consumer, "nuke", nuclearReactor, "I've become Death, Destroyer of Worlds", "Craft a Nuke", existingFileHelper);
        AdvancementHolder singularity = this.createBasic(consumer, "singularity", nuke, "Pocket Black Hole", "Craft a Singularity", existingFileHelper);
        AdvancementHolder mixedIngotIridium = this.createBasic(consumer, "mixed_ingot_iridium", implosionCompressor, "Oreo Ingot", "Craft a Mixed Ingot Iridium to craft Iridium Plates", existingFileHelper);
        AdvancementHolder quantumCircuit = this.createBasic(consumer, "quantum_circuit", mixedIngotIridium, AdvancementType.GOAL, "Mobius Strip Eigenvalues", "Craft a Quantum Circuit", existingFileHelper);
        AdvancementHolder fusionReactor = this.createBasic(consumer, "fusion_reactor", quantumCircuit, AdvancementType.CHALLENGE, "Enslaved Star Core", "Craft a Fusion Reactor to produce insane amount of energy", existingFileHelper);
        AdvancementHolder plasmaTurbine = this.createBasic(consumer, "plasma_turbine", fusionReactor, "Better than Nuclear Fission", "Craft a Plasma Turbine to transform Helium Plasma into energy", existingFileHelper);
        AdvancementHolder basicUpgrade = this.createBasic(consumer, "basic_upgrade", assembler, AdvancementType.GOAL, "Machine Speedup", "Craft a Basic Upgrade to increase the maximum speed of an electric recipe", existingFileHelper);
        AdvancementHolder advancedUpgrade = this.createBasic(consumer, "advanced_upgrade", chemicalReactor, "Machine Speedup-Speedup", "Craft a Advanced Upgrade", existingFileHelper);
        AdvancementHolder turboUpgrade = this.createBasic(consumer, "turbo_upgrade", digitalCircuit, "Gotta go Fast", "Craft a Turbo Upgrade", existingFileHelper);
        AdvancementHolder highlyAdvancedUpgrade = this.createBasic(consumer, "highly_advanced_upgrade", processingUnit, "I'm speed", "Craft an Highly Advanced Upgrade", existingFileHelper);
        AdvancementHolder quantumUpgrade = this.createBasic(consumer, "quantum_upgrade", quantumCircuit, AdvancementType.GOAL, "Time Dilation", "Craft a Quantum Upgrade to unlock unlimited recipe speed", existingFileHelper);
        AdvancementHolder replicator = this.createBasic(consumer, "replicator", quantumUpgrade, AdvancementType.CHALLENGE, "Legal Duping", "Craft a Replicator and replicate any item you want using UU Matter", existingFileHelper);
        AdvancementHolder uuMatter = this.createBasic(consumer, "uu_matter_bucket", singularity, AdvancementType.GOAL, "Liquid Creative Mode", "Produce a bucket of UU Matter to start duplication in the replicator", existingFileHelper);
        AdvancementHolder quantumSword = this.createBasic(consumer, "quantum_sword", quantumUpgrade, AdvancementType.CHALLENGE, "Annihilation Operator", "Craft a Quantum Sword and disintegrate your foes (or the Wandering Trader llama's)", existingFileHelper);
        AdvancementHolder quantumChestplate = this.createBasic(consumer, "quantum_chestplate", quantumUpgrade, AdvancementType.CHALLENGE, "Quantum Immortality\u2122", "Craft a Quantum Chestplate to reduce the probability of taking any damage by 25% for each piece of the Quantum Armor Set", existingFileHelper);
    }

    private AdvancementHolder createBasic(Consumer<AdvancementHolder> consumer, String item, AdvancementHolder parent, String titleEnglishName, String englishDescription, ExistingFileHelper existingFileHelper) {
        return this.createBasic(consumer, item, parent, AdvancementType.TASK, titleEnglishName, englishDescription, existingFileHelper);
    }

    private AdvancementHolder createBasic(Consumer<AdvancementHolder> consumer, String itemId, AdvancementHolder parent, AdvancementType frame, String titleEnglishName, String englishDescription, ExistingFileHelper existingFileHelper) {
        Item item = (Item)BuiltInRegistries.ITEM.get(MI.id(itemId));
        Builder advancementTask = this.newBuilder(itemId);
        advancementTask.parent(parent);
        advancementTask.display((ItemLike)item, titleEnglishName, englishDescription, null, frame, true, true, false);
        advancementTask.addCriterion("checkInv", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
        return advancementTask.save(consumer, existingFileHelper);
    }

    private class Builder
    extends Advancement.Builder {
        private final String path;

        private Builder(String path) {
            this.path = path;
        }

        public Builder sendsTelemetryEvent() {
            return (Builder)super.sendsTelemetryEvent();
        }

        public Builder display(ItemLike pIcon, Component pTitle, Component pDescription, @Nullable ResourceLocation pBackground, AdvancementType pType, boolean pShowToast, boolean pAnnounceChat, boolean pHidden) {
            return (Builder)super.display(pIcon, pTitle, pDescription, pBackground, pType, pShowToast, pAnnounceChat, pHidden);
        }

        public Builder display(ItemLike icon, String titleEnglishName, String englishDescription, @Nullable ResourceLocation pBackground, AdvancementType pType, boolean pShowToast, boolean pAnnounceChat, boolean pHidden) {
            return this.display(icon, MIAdvancementsProvider.this.translateTitle(this.path, titleEnglishName), MIAdvancementsProvider.this.translateDescription(this.path, englishDescription), pBackground, pType, pShowToast, pAnnounceChat, pHidden);
        }

        public Builder parent(AdvancementHolder pParent) {
            return (Builder)super.parent(pParent);
        }

        public Builder addCriterion(String pKey, Criterion<?> pCriterion) {
            return (Builder)super.addCriterion(pKey, pCriterion);
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            return this.save(consumer, MI.id(this.path), existingFileHelper);
        }
    }
}

