/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.CheckReturnValue;

public class MIConfigBuilder {
    public static final Map<String, String> configTranslations = new ConcurrentHashMap<String, String>();
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();

    private static String configTranslationKey(String key) {
        return "modern_industrialization.configuration." + key;
    }

    public void pushSection(String key, String title) {
        String sectionTranslation = MIConfigBuilder.configTranslationKey(key);
        configTranslations.put(sectionTranslation, title);
        this.builder.push(key);
    }

    public void popSection() {
        this.builder.pop();
    }

    @CheckReturnValue
    public ModConfigSpec.Builder start(String key, String title, String ... comment) {
        if (comment.length == 0) {
            throw new IllegalArgumentException("Comment cannot be empty");
        }
        String translationKey = MIConfigBuilder.configTranslationKey(key);
        configTranslations.put(translationKey, title);
        configTranslations.put(translationKey + ".tooltip", String.join((CharSequence)" ", comment));
        return this.builder.translation(translationKey).comment(comment);
    }

    public ModConfigSpec build() {
        return this.builder.build();
    }
}

