/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidOutputComponent
extends SimpleRecipeComponent<MachineRecipe.FluidOutput> {
    public static final RecipeComponentType<MachineRecipe.FluidOutput> TYPE = RecipeComponentType.unit((ResourceLocation)MI.id("fluid_output"), FluidOutputComponent::new);

    public FluidOutputComponent(RecipeComponentType<?> type) {
        super(type, MachineRecipe.FluidOutput.CODEC, FluidWrapper.TYPE_INFO);
    }

    public MachineRecipe.FluidOutput wrap(RecipeScriptContext cx, Object from) {
        FluidStack fs = FluidWrapper.wrap((Context)cx.cx(), (Object)from);
        return new MachineRecipe.FluidOutput(fs.getFluid(), fs.getAmount(), 1.0f);
    }

    public boolean matches(RecipeMatchContext cx, MachineRecipe.FluidOutput value, ReplacementMatchInfo match) {
        FluidMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof FluidMatch && (m = (FluidMatch)replacementMatch).matches(cx, new FluidStack(value.fluid(), 1), match.exact());
    }

    public MachineRecipe.FluidOutput replace(RecipeScriptContext cx, MachineRecipe.FluidOutput original, ReplacementMatchInfo match, Object with) {
        if (this.matches((RecipeMatchContext)cx, original, match)) {
            FluidStack fs = FluidWrapper.wrap((Context)cx.cx(), (Object)with);
            return new MachineRecipe.FluidOutput(fs.getFluid(), original.amount(), original.probability());
        }
        return original;
    }

    public boolean isEmpty(MachineRecipe.FluidOutput value) {
        return value.amount() <= 0L || value.fluid().isSame(Fluids.EMPTY);
    }

    public void buildUniqueId(UniqueIdBuilder builder, MachineRecipe.FluidOutput value) {
        if (!this.isEmpty(value)) {
            builder.append(value.fluid().builtInRegistryHolder().getKey().location());
        }
    }
}

